package zio.aws.mturk.model
import zio.prelude.data.Optional
import zio.aws.mturk.model.primitives.{ResultSize, PaginationToken, EntityId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListReviewPolicyResultsForHitRequest(
    hitId: EntityId,
    policyLevels: Optional[Iterable[zio.aws.mturk.model.ReviewPolicyLevel]] =
      Optional.Absent,
    retrieveActions: Optional[Boolean] = Optional.Absent,
    retrieveResults: Optional[Boolean] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[ResultSize] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitRequest = {
    import ListReviewPolicyResultsForHitRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitRequest
      .builder()
      .hitId(EntityId.unwrap(hitId): java.lang.String)
      .optionallyWith(
        policyLevels.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.policyLevelsWithStrings)
      .optionallyWith(retrieveActions.map(value => value: java.lang.Boolean))(
        _.retrieveActions
      )
      .optionallyWith(retrieveResults.map(value => value: java.lang.Boolean))(
        _.retrieveResults
      )
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ResultSize.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.mturk.model.ListReviewPolicyResultsForHitRequest.ReadOnly =
    zio.aws.mturk.model.ListReviewPolicyResultsForHitRequest
      .wrap(buildAwsValue())
}
object ListReviewPolicyResultsForHitRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.ListReviewPolicyResultsForHitRequest =
      zio.aws.mturk.model.ListReviewPolicyResultsForHitRequest(
        hitId,
        policyLevels.map(value => value),
        retrieveActions.map(value => value),
        retrieveResults.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def hitId: EntityId
    def policyLevels: Optional[List[zio.aws.mturk.model.ReviewPolicyLevel]]
    def retrieveActions: Optional[Boolean]
    def retrieveResults: Optional[Boolean]
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[ResultSize]
    def getHitId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(hitId)
    def getPolicyLevels
        : ZIO[Any, AwsError, List[zio.aws.mturk.model.ReviewPolicyLevel]] =
      AwsError.unwrapOptionField("policyLevels", policyLevels)
    def getRetrieveActions: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("retrieveActions", retrieveActions)
    def getRetrieveResults: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("retrieveResults", retrieveResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ResultSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitRequest
  ) extends zio.aws.mturk.model.ListReviewPolicyResultsForHitRequest.ReadOnly {
    override val hitId: EntityId =
      zio.aws.mturk.model.primitives.EntityId(impl.hitId())
    override val policyLevels
        : Optional[List[zio.aws.mturk.model.ReviewPolicyLevel]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyLevels())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mturk.model.ReviewPolicyLevel.wrap(item)
          }.toList
        )
    override val retrieveActions: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.retrieveActions())
      .map(value => value: Boolean)
    override val retrieveResults: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.retrieveResults())
      .map(value => value: Boolean)
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.mturk.model.primitives.PaginationToken(value))
    override val maxResults: Optional[ResultSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.mturk.model.primitives.ResultSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitRequest
  ): zio.aws.mturk.model.ListReviewPolicyResultsForHitRequest.ReadOnly =
    new Wrapper(impl)
}
