package zio.aws.mturk.model
import zio.prelude.data.Optional
import zio.aws.mturk.model.primitives.{ResultSize, PaginationToken, EntityId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListWorkersWithQualificationTypeRequest(
    qualificationTypeId: EntityId,
    status: Optional[zio.aws.mturk.model.QualificationStatus] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[ResultSize] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeRequest = {
    import ListWorkersWithQualificationTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeRequest
      .builder()
      .qualificationTypeId(
        EntityId.unwrap(qualificationTypeId): java.lang.String
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ResultSize.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.mturk.model.ListWorkersWithQualificationTypeRequest.ReadOnly =
    zio.aws.mturk.model.ListWorkersWithQualificationTypeRequest
      .wrap(buildAwsValue())
}
object ListWorkersWithQualificationTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.mturk.model.ListWorkersWithQualificationTypeRequest =
      zio.aws.mturk.model.ListWorkersWithQualificationTypeRequest(
        qualificationTypeId,
        status.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def qualificationTypeId: EntityId
    def status: Optional[zio.aws.mturk.model.QualificationStatus]
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[ResultSize]
    def getQualificationTypeId: ZIO[Any, Nothing, EntityId] =
      ZIO.succeed(qualificationTypeId)
    def getStatus: ZIO[Any, AwsError, zio.aws.mturk.model.QualificationStatus] =
      AwsError.unwrapOptionField("status", status)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ResultSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeRequest
  ) extends zio.aws.mturk.model.ListWorkersWithQualificationTypeRequest.ReadOnly {
    override val qualificationTypeId: EntityId =
      zio.aws.mturk.model.primitives.EntityId(impl.qualificationTypeId())
    override val status: Optional[zio.aws.mturk.model.QualificationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.mturk.model.QualificationStatus.wrap(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.mturk.model.primitives.PaginationToken(value))
    override val maxResults: Optional[ResultSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.mturk.model.primitives.ResultSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeRequest
  ): zio.aws.mturk.model.ListWorkersWithQualificationTypeRequest.ReadOnly =
    new Wrapper(impl)
}
