package zio.aws.mturk.model
import scala.jdk.CollectionConverters._
sealed trait NotificationTransport {
  def unwrap: software.amazon.awssdk.services.mturk.model.NotificationTransport
}
object NotificationTransport {
  def wrap(
      value: software.amazon.awssdk.services.mturk.model.NotificationTransport
  ): zio.aws.mturk.model.NotificationTransport = value match {
    case software.amazon.awssdk.services.mturk.model.NotificationTransport.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mturk.model.NotificationTransport.EMAIL =>
      val r = Email
      r
    case software.amazon.awssdk.services.mturk.model.NotificationTransport.SQS =>
      val r = SQS
      r
    case software.amazon.awssdk.services.mturk.model.NotificationTransport.SNS =>
      val r = SNS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mturk.model.NotificationTransport {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.NotificationTransport =
      software.amazon.awssdk.services.mturk.model.NotificationTransport.UNKNOWN_TO_SDK_VERSION
  }
  case object Email extends zio.aws.mturk.model.NotificationTransport {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.NotificationTransport =
      software.amazon.awssdk.services.mturk.model.NotificationTransport.EMAIL
  }
  case object SQS extends zio.aws.mturk.model.NotificationTransport {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.NotificationTransport =
      software.amazon.awssdk.services.mturk.model.NotificationTransport.SQS
  }
  case object SNS extends zio.aws.mturk.model.NotificationTransport {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.NotificationTransport =
      software.amazon.awssdk.services.mturk.model.NotificationTransport.SNS
  }
}
