package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mturk.model.primitives.CustomerId
import scala.jdk.CollectionConverters._
final case class NotifyWorkersRequest(
    subject: String,
    messageText: String,
    workerIds: Iterable[CustomerId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.NotifyWorkersRequest = {
    import NotifyWorkersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.NotifyWorkersRequest
      .builder()
      .subject(subject: java.lang.String)
      .messageText(messageText: java.lang.String)
      .workerIds(workerIds.map { item =>
        CustomerId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.NotifyWorkersRequest.ReadOnly =
    zio.aws.mturk.model.NotifyWorkersRequest.wrap(buildAwsValue())
}
object NotifyWorkersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.NotifyWorkersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.NotifyWorkersRequest =
      zio.aws.mturk.model.NotifyWorkersRequest(subject, messageText, workerIds)
    def subject: String
    def messageText: String
    def workerIds: List[CustomerId]
    def getSubject: ZIO[Any, Nothing, String] = ZIO.succeed(subject)
    def getMessageText: ZIO[Any, Nothing, String] = ZIO.succeed(messageText)
    def getWorkerIds: ZIO[Any, Nothing, List[CustomerId]] =
      ZIO.succeed(workerIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.NotifyWorkersRequest
  ) extends zio.aws.mturk.model.NotifyWorkersRequest.ReadOnly {
    override val subject: String = impl.subject(): String
    override val messageText: String = impl.messageText(): String
    override val workerIds: List[CustomerId] = impl
      .workerIds()
      .asScala
      .map { item =>
        zio.aws.mturk.model.primitives.CustomerId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.NotifyWorkersRequest
  ): zio.aws.mturk.model.NotifyWorkersRequest.ReadOnly = new Wrapper(impl)
}
