package zio.aws.mturk.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.mturk.model.primitives.{Integer, Timestamp, EntityId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class QualificationType(
    qualificationTypeId: Optional[EntityId] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    keywords: Optional[String] = Optional.Absent,
    qualificationTypeStatus: Optional[
      zio.aws.mturk.model.QualificationTypeStatus
    ] = Optional.Absent,
    test: Optional[String] = Optional.Absent,
    testDurationInSeconds: Optional[Long] = Optional.Absent,
    answerKey: Optional[String] = Optional.Absent,
    retryDelayInSeconds: Optional[Long] = Optional.Absent,
    isRequestable: Optional[Boolean] = Optional.Absent,
    autoGranted: Optional[Boolean] = Optional.Absent,
    autoGrantedValue: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.QualificationType = {
    import QualificationType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.QualificationType
      .builder()
      .optionallyWith(
        qualificationTypeId.map(value =>
          EntityId.unwrap(value): java.lang.String
        )
      )(_.qualificationTypeId)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(keywords.map(value => value: java.lang.String))(
        _.keywords
      )
      .optionallyWith(qualificationTypeStatus.map(value => value.unwrap))(
        _.qualificationTypeStatus
      )
      .optionallyWith(test.map(value => value: java.lang.String))(_.test)
      .optionallyWith(
        testDurationInSeconds.map(value => value: java.lang.Long)
      )(_.testDurationInSeconds)
      .optionallyWith(answerKey.map(value => value: java.lang.String))(
        _.answerKey
      )
      .optionallyWith(retryDelayInSeconds.map(value => value: java.lang.Long))(
        _.retryDelayInSeconds
      )
      .optionallyWith(isRequestable.map(value => value: java.lang.Boolean))(
        _.isRequestable
      )
      .optionallyWith(autoGranted.map(value => value: java.lang.Boolean))(
        _.autoGranted
      )
      .optionallyWith(autoGrantedValue.map(value => value: java.lang.Integer))(
        _.autoGrantedValue
      )
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.QualificationType.ReadOnly =
    zio.aws.mturk.model.QualificationType.wrap(buildAwsValue())
}
object QualificationType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.QualificationType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.QualificationType =
      zio.aws.mturk.model.QualificationType(
        qualificationTypeId.map(value => value),
        creationTime.map(value => value),
        name.map(value => value),
        description.map(value => value),
        keywords.map(value => value),
        qualificationTypeStatus.map(value => value),
        test.map(value => value),
        testDurationInSeconds.map(value => value),
        answerKey.map(value => value),
        retryDelayInSeconds.map(value => value),
        isRequestable.map(value => value),
        autoGranted.map(value => value),
        autoGrantedValue.map(value => value)
      )
    def qualificationTypeId: Optional[EntityId]
    def creationTime: Optional[Timestamp]
    def name: Optional[String]
    def description: Optional[String]
    def keywords: Optional[String]
    def qualificationTypeStatus
        : Optional[zio.aws.mturk.model.QualificationTypeStatus]
    def test: Optional[String]
    def testDurationInSeconds: Optional[Long]
    def answerKey: Optional[String]
    def retryDelayInSeconds: Optional[Long]
    def isRequestable: Optional[Boolean]
    def autoGranted: Optional[Boolean]
    def autoGrantedValue: Optional[Integer]
    def getQualificationTypeId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("qualificationTypeId", qualificationTypeId)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getKeywords: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keywords", keywords)
    def getQualificationTypeStatus
        : ZIO[Any, AwsError, zio.aws.mturk.model.QualificationTypeStatus] =
      AwsError.unwrapOptionField(
        "qualificationTypeStatus",
        qualificationTypeStatus
      )
    def getTest: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("test", test)
    def getTestDurationInSeconds: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("testDurationInSeconds", testDurationInSeconds)
    def getAnswerKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("answerKey", answerKey)
    def getRetryDelayInSeconds: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("retryDelayInSeconds", retryDelayInSeconds)
    def getIsRequestable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isRequestable", isRequestable)
    def getAutoGranted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoGranted", autoGranted)
    def getAutoGrantedValue: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("autoGrantedValue", autoGrantedValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.QualificationType
  ) extends zio.aws.mturk.model.QualificationType.ReadOnly {
    override val qualificationTypeId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.qualificationTypeId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.mturk.model.primitives.Timestamp(value))
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val keywords: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.keywords())
      .map(value => value: String)
    override val qualificationTypeStatus
        : Optional[zio.aws.mturk.model.QualificationTypeStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.qualificationTypeStatus())
        .map(value => zio.aws.mturk.model.QualificationTypeStatus.wrap(value))
    override val test: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.test())
      .map(value => value: String)
    override val testDurationInSeconds: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.testDurationInSeconds())
      .map(value => value: Long)
    override val answerKey: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.answerKey())
      .map(value => value: String)
    override val retryDelayInSeconds: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.retryDelayInSeconds())
      .map(value => value: Long)
    override val isRequestable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isRequestable())
      .map(value => value: Boolean)
    override val autoGranted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.autoGranted())
      .map(value => value: Boolean)
    override val autoGrantedValue: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.autoGrantedValue())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.QualificationType
  ): zio.aws.mturk.model.QualificationType.ReadOnly = new Wrapper(impl)
}
