package zio.aws.mturk.model
import scala.jdk.CollectionConverters._
sealed trait QualificationTypeStatus {
  def unwrap
      : software.amazon.awssdk.services.mturk.model.QualificationTypeStatus
}
object QualificationTypeStatus {
  def wrap(
      value: software.amazon.awssdk.services.mturk.model.QualificationTypeStatus
  ): zio.aws.mturk.model.QualificationTypeStatus = value match {
    case software.amazon.awssdk.services.mturk.model.QualificationTypeStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mturk.model.QualificationTypeStatus.ACTIVE =>
      val r = Active
      r
    case software.amazon.awssdk.services.mturk.model.QualificationTypeStatus.INACTIVE =>
      val r = Inactive
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mturk.model.QualificationTypeStatus {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.QualificationTypeStatus =
      software.amazon.awssdk.services.mturk.model.QualificationTypeStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Active extends zio.aws.mturk.model.QualificationTypeStatus {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.QualificationTypeStatus =
      software.amazon.awssdk.services.mturk.model.QualificationTypeStatus.ACTIVE
  }
  case object Inactive extends zio.aws.mturk.model.QualificationTypeStatus {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.QualificationTypeStatus =
      software.amazon.awssdk.services.mturk.model.QualificationTypeStatus.INACTIVE
  }
}
