package zio.aws.mturk.model
import scala.jdk.CollectionConverters._
sealed trait ReviewableHITStatus {
  def unwrap: software.amazon.awssdk.services.mturk.model.ReviewableHITStatus
}
object ReviewableHITStatus {
  def wrap(
      value: software.amazon.awssdk.services.mturk.model.ReviewableHITStatus
  ): zio.aws.mturk.model.ReviewableHITStatus = value match {
    case software.amazon.awssdk.services.mturk.model.ReviewableHITStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mturk.model.ReviewableHITStatus.REVIEWABLE =>
      val r = Reviewable
      r
    case software.amazon.awssdk.services.mturk.model.ReviewableHITStatus.REVIEWING =>
      val r = Reviewing
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mturk.model.ReviewableHITStatus {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.ReviewableHITStatus =
      software.amazon.awssdk.services.mturk.model.ReviewableHITStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Reviewable extends zio.aws.mturk.model.ReviewableHITStatus {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.ReviewableHITStatus =
      software.amazon.awssdk.services.mturk.model.ReviewableHITStatus.REVIEWABLE
  }
  case object Reviewing extends zio.aws.mturk.model.ReviewableHITStatus {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.ReviewableHITStatus =
      software.amazon.awssdk.services.mturk.model.ReviewableHITStatus.REVIEWING
  }
}
