package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.Integer
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AcceptQualificationRequestRequest(
    qualificationRequestId: String,
    integerValue: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.AcceptQualificationRequestRequest = {
    import AcceptQualificationRequestRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.AcceptQualificationRequestRequest
      .builder()
      .qualificationRequestId(qualificationRequestId: java.lang.String)
      .optionallyWith(integerValue.map(value => value: java.lang.Integer))(
        _.integerValue
      )
      .build()
  }
  def asReadOnly
      : zio.aws.mturk.model.AcceptQualificationRequestRequest.ReadOnly =
    zio.aws.mturk.model.AcceptQualificationRequestRequest.wrap(buildAwsValue())
}
object AcceptQualificationRequestRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.AcceptQualificationRequestRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.AcceptQualificationRequestRequest =
      zio.aws.mturk.model.AcceptQualificationRequestRequest(
        qualificationRequestId,
        integerValue.map(value => value)
      )
    def qualificationRequestId: String
    def integerValue: Optional[Integer]
    def getQualificationRequestId: ZIO[Any, Nothing, String] =
      ZIO.succeed(qualificationRequestId)
    def getIntegerValue: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("integerValue", integerValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.AcceptQualificationRequestRequest
  ) extends zio.aws.mturk.model.AcceptQualificationRequestRequest.ReadOnly {
    override val qualificationRequestId: String =
      impl.qualificationRequestId(): String
    override val integerValue: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.integerValue())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.AcceptQualificationRequestRequest
  ): zio.aws.mturk.model.AcceptQualificationRequestRequest.ReadOnly =
    new Wrapper(impl)
}
