package zio.aws.mturk.model
import scala.jdk.CollectionConverters._
sealed trait AssignmentStatus {
  def unwrap: software.amazon.awssdk.services.mturk.model.AssignmentStatus
}
object AssignmentStatus {
  def wrap(
      value: software.amazon.awssdk.services.mturk.model.AssignmentStatus
  ): zio.aws.mturk.model.AssignmentStatus = value match {
    case software.amazon.awssdk.services.mturk.model.AssignmentStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mturk.model.AssignmentStatus.SUBMITTED =>
      val r = Submitted
      r
    case software.amazon.awssdk.services.mturk.model.AssignmentStatus.APPROVED =>
      val r = Approved
      r
    case software.amazon.awssdk.services.mturk.model.AssignmentStatus.REJECTED =>
      val r = Rejected
      r
  }
  case object unknownToSdkVersion extends zio.aws.mturk.model.AssignmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.AssignmentStatus =
      software.amazon.awssdk.services.mturk.model.AssignmentStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Submitted extends zio.aws.mturk.model.AssignmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.AssignmentStatus =
      software.amazon.awssdk.services.mturk.model.AssignmentStatus.SUBMITTED
  }
  case object Approved extends zio.aws.mturk.model.AssignmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.AssignmentStatus =
      software.amazon.awssdk.services.mturk.model.AssignmentStatus.APPROVED
  }
  case object Rejected extends zio.aws.mturk.model.AssignmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.AssignmentStatus =
      software.amazon.awssdk.services.mturk.model.AssignmentStatus.REJECTED
  }
}
