package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.{Integer, CustomerId, EntityId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociateQualificationWithWorkerRequest(
    qualificationTypeId: EntityId,
    workerId: CustomerId,
    integerValue: Optional[Integer] = Optional.Absent,
    sendNotification: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.AssociateQualificationWithWorkerRequest = {
    import AssociateQualificationWithWorkerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.AssociateQualificationWithWorkerRequest
      .builder()
      .qualificationTypeId(
        EntityId.unwrap(qualificationTypeId): java.lang.String
      )
      .workerId(CustomerId.unwrap(workerId): java.lang.String)
      .optionallyWith(integerValue.map(value => value: java.lang.Integer))(
        _.integerValue
      )
      .optionallyWith(sendNotification.map(value => value: java.lang.Boolean))(
        _.sendNotification
      )
      .build()
  }
  def asReadOnly
      : zio.aws.mturk.model.AssociateQualificationWithWorkerRequest.ReadOnly =
    zio.aws.mturk.model.AssociateQualificationWithWorkerRequest
      .wrap(buildAwsValue())
}
object AssociateQualificationWithWorkerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.AssociateQualificationWithWorkerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.mturk.model.AssociateQualificationWithWorkerRequest =
      zio.aws.mturk.model.AssociateQualificationWithWorkerRequest(
        qualificationTypeId,
        workerId,
        integerValue.map(value => value),
        sendNotification.map(value => value)
      )
    def qualificationTypeId: EntityId
    def workerId: CustomerId
    def integerValue: Optional[Integer]
    def sendNotification: Optional[Boolean]
    def getQualificationTypeId: ZIO[Any, Nothing, EntityId] =
      ZIO.succeed(qualificationTypeId)
    def getWorkerId: ZIO[Any, Nothing, CustomerId] = ZIO.succeed(workerId)
    def getIntegerValue: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("integerValue", integerValue)
    def getSendNotification: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("sendNotification", sendNotification)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.AssociateQualificationWithWorkerRequest
  ) extends zio.aws.mturk.model.AssociateQualificationWithWorkerRequest.ReadOnly {
    override val qualificationTypeId: EntityId =
      zio.aws.mturk.model.primitives.EntityId(impl.qualificationTypeId())
    override val workerId: CustomerId =
      zio.aws.mturk.model.primitives.CustomerId(impl.workerId())
    override val integerValue: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.integerValue())
      .map(value => value: Integer)
    override val sendNotification: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.sendNotification())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.AssociateQualificationWithWorkerRequest
  ): zio.aws.mturk.model.AssociateQualificationWithWorkerRequest.ReadOnly =
    new Wrapper(impl)
}
