package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.{IdempotencyToken, Integer, EntityId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAdditionalAssignmentsForHitRequest(
    hitId: EntityId,
    numberOfAdditionalAssignments: Integer,
    uniqueRequestToken: Optional[IdempotencyToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.CreateAdditionalAssignmentsForHitRequest = {
    import CreateAdditionalAssignmentsForHitRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.CreateAdditionalAssignmentsForHitRequest
      .builder()
      .hitId(EntityId.unwrap(hitId): java.lang.String)
      .numberOfAdditionalAssignments(
        numberOfAdditionalAssignments: java.lang.Integer
      )
      .optionallyWith(
        uniqueRequestToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.uniqueRequestToken)
      .build()
  }
  def asReadOnly
      : zio.aws.mturk.model.CreateAdditionalAssignmentsForHitRequest.ReadOnly =
    zio.aws.mturk.model.CreateAdditionalAssignmentsForHitRequest
      .wrap(buildAwsValue())
}
object CreateAdditionalAssignmentsForHitRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.CreateAdditionalAssignmentsForHitRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.mturk.model.CreateAdditionalAssignmentsForHitRequest =
      zio.aws.mturk.model.CreateAdditionalAssignmentsForHitRequest(
        hitId,
        numberOfAdditionalAssignments,
        uniqueRequestToken.map(value => value)
      )
    def hitId: EntityId
    def numberOfAdditionalAssignments: Integer
    def uniqueRequestToken: Optional[IdempotencyToken]
    def getHitId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(hitId)
    def getNumberOfAdditionalAssignments: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(numberOfAdditionalAssignments)
    def getUniqueRequestToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("uniqueRequestToken", uniqueRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.CreateAdditionalAssignmentsForHitRequest
  ) extends zio.aws.mturk.model.CreateAdditionalAssignmentsForHitRequest.ReadOnly {
    override val hitId: EntityId =
      zio.aws.mturk.model.primitives.EntityId(impl.hitId())
    override val numberOfAdditionalAssignments: Integer =
      impl.numberOfAdditionalAssignments(): Integer
    override val uniqueRequestToken: Optional[IdempotencyToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.uniqueRequestToken())
        .map(value => zio.aws.mturk.model.primitives.IdempotencyToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.CreateAdditionalAssignmentsForHitRequest
  ): zio.aws.mturk.model.CreateAdditionalAssignmentsForHitRequest.ReadOnly =
    new Wrapper(impl)
}
