package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.{IdempotencyToken, Integer, EntityId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateHitWithHitTypeRequest(
    hitTypeId: EntityId,
    maxAssignments: Optional[Integer] = Optional.Absent,
    lifetimeInSeconds: Long,
    question: Optional[String] = Optional.Absent,
    requesterAnnotation: Optional[String] = Optional.Absent,
    uniqueRequestToken: Optional[IdempotencyToken] = Optional.Absent,
    assignmentReviewPolicy: Optional[zio.aws.mturk.model.ReviewPolicy] =
      Optional.Absent,
    hitReviewPolicy: Optional[zio.aws.mturk.model.ReviewPolicy] =
      Optional.Absent,
    hitLayoutId: Optional[EntityId] = Optional.Absent,
    hitLayoutParameters: Optional[
      Iterable[zio.aws.mturk.model.HITLayoutParameter]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.CreateHitWithHitTypeRequest = {
    import CreateHitWithHitTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.CreateHitWithHitTypeRequest
      .builder()
      .hitTypeId(EntityId.unwrap(hitTypeId): java.lang.String)
      .optionallyWith(maxAssignments.map(value => value: java.lang.Integer))(
        _.maxAssignments
      )
      .lifetimeInSeconds(lifetimeInSeconds: java.lang.Long)
      .optionallyWith(question.map(value => value: java.lang.String))(
        _.question
      )
      .optionallyWith(
        requesterAnnotation.map(value => value: java.lang.String)
      )(_.requesterAnnotation)
      .optionallyWith(
        uniqueRequestToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.uniqueRequestToken)
      .optionallyWith(
        assignmentReviewPolicy.map(value => value.buildAwsValue())
      )(_.assignmentReviewPolicy)
      .optionallyWith(hitReviewPolicy.map(value => value.buildAwsValue()))(
        _.hitReviewPolicy
      )
      .optionallyWith(
        hitLayoutId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.hitLayoutId)
      .optionallyWith(
        hitLayoutParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hitLayoutParameters)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.CreateHitWithHitTypeRequest.ReadOnly =
    zio.aws.mturk.model.CreateHitWithHitTypeRequest.wrap(buildAwsValue())
}
object CreateHitWithHitTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.CreateHitWithHitTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.CreateHitWithHitTypeRequest =
      zio.aws.mturk.model.CreateHitWithHitTypeRequest(
        hitTypeId,
        maxAssignments.map(value => value),
        lifetimeInSeconds,
        question.map(value => value),
        requesterAnnotation.map(value => value),
        uniqueRequestToken.map(value => value),
        assignmentReviewPolicy.map(value => value.asEditable),
        hitReviewPolicy.map(value => value.asEditable),
        hitLayoutId.map(value => value),
        hitLayoutParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def hitTypeId: EntityId
    def maxAssignments: Optional[Integer]
    def lifetimeInSeconds: Long
    def question: Optional[String]
    def requesterAnnotation: Optional[String]
    def uniqueRequestToken: Optional[IdempotencyToken]
    def assignmentReviewPolicy
        : Optional[zio.aws.mturk.model.ReviewPolicy.ReadOnly]
    def hitReviewPolicy: Optional[zio.aws.mturk.model.ReviewPolicy.ReadOnly]
    def hitLayoutId: Optional[EntityId]
    def hitLayoutParameters
        : Optional[List[zio.aws.mturk.model.HITLayoutParameter.ReadOnly]]
    def getHitTypeId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(hitTypeId)
    def getMaxAssignments: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxAssignments", maxAssignments)
    def getLifetimeInSeconds: ZIO[Any, Nothing, Long] =
      ZIO.succeed(lifetimeInSeconds)
    def getQuestion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("question", question)
    def getRequesterAnnotation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("requesterAnnotation", requesterAnnotation)
    def getUniqueRequestToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("uniqueRequestToken", uniqueRequestToken)
    def getAssignmentReviewPolicy
        : ZIO[Any, AwsError, zio.aws.mturk.model.ReviewPolicy.ReadOnly] =
      AwsError.unwrapOptionField(
        "assignmentReviewPolicy",
        assignmentReviewPolicy
      )
    def getHitReviewPolicy
        : ZIO[Any, AwsError, zio.aws.mturk.model.ReviewPolicy.ReadOnly] =
      AwsError.unwrapOptionField("hitReviewPolicy", hitReviewPolicy)
    def getHitLayoutId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("hitLayoutId", hitLayoutId)
    def getHitLayoutParameters: ZIO[Any, AwsError, List[
      zio.aws.mturk.model.HITLayoutParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("hitLayoutParameters", hitLayoutParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.CreateHitWithHitTypeRequest
  ) extends zio.aws.mturk.model.CreateHitWithHitTypeRequest.ReadOnly {
    override val hitTypeId: EntityId =
      zio.aws.mturk.model.primitives.EntityId(impl.hitTypeId())
    override val maxAssignments: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxAssignments())
      .map(value => value: Integer)
    override val lifetimeInSeconds: Long = impl.lifetimeInSeconds(): Long
    override val question: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.question())
      .map(value => value: String)
    override val requesterAnnotation: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.requesterAnnotation())
      .map(value => value: String)
    override val uniqueRequestToken: Optional[IdempotencyToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.uniqueRequestToken())
        .map(value => zio.aws.mturk.model.primitives.IdempotencyToken(value))
    override val assignmentReviewPolicy
        : Optional[zio.aws.mturk.model.ReviewPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assignmentReviewPolicy())
        .map(value => zio.aws.mturk.model.ReviewPolicy.wrap(value))
    override val hitReviewPolicy
        : Optional[zio.aws.mturk.model.ReviewPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hitReviewPolicy())
        .map(value => zio.aws.mturk.model.ReviewPolicy.wrap(value))
    override val hitLayoutId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.hitLayoutId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
    override val hitLayoutParameters
        : Optional[List[zio.aws.mturk.model.HITLayoutParameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hitLayoutParameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mturk.model.HITLayoutParameter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.CreateHitWithHitTypeRequest
  ): zio.aws.mturk.model.CreateHitWithHitTypeRequest.ReadOnly = new Wrapper(
    impl
  )
}
