package zio.aws.mturk.model
import scala.jdk.CollectionConverters._
sealed trait EventType {
  def unwrap: software.amazon.awssdk.services.mturk.model.EventType
}
object EventType {
  def wrap(
      value: software.amazon.awssdk.services.mturk.model.EventType
  ): zio.aws.mturk.model.EventType = value match {
    case software.amazon.awssdk.services.mturk.model.EventType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mturk.model.EventType.ASSIGNMENT_ACCEPTED =>
      val r = AssignmentAccepted
      r
    case software.amazon.awssdk.services.mturk.model.EventType.ASSIGNMENT_ABANDONED =>
      val r = AssignmentAbandoned
      r
    case software.amazon.awssdk.services.mturk.model.EventType.ASSIGNMENT_RETURNED =>
      val r = AssignmentReturned
      r
    case software.amazon.awssdk.services.mturk.model.EventType.ASSIGNMENT_SUBMITTED =>
      val r = AssignmentSubmitted
      r
    case software.amazon.awssdk.services.mturk.model.EventType.ASSIGNMENT_REJECTED =>
      val r = AssignmentRejected
      r
    case software.amazon.awssdk.services.mturk.model.EventType.ASSIGNMENT_APPROVED =>
      val r = AssignmentApproved
      r
    case software.amazon.awssdk.services.mturk.model.EventType.HIT_CREATED =>
      val r = HITCreated
      r
    case software.amazon.awssdk.services.mturk.model.EventType.HIT_EXPIRED =>
      val r = HITExpired
      r
    case software.amazon.awssdk.services.mturk.model.EventType.HIT_REVIEWABLE =>
      val r = HITReviewable
      r
    case software.amazon.awssdk.services.mturk.model.EventType.HIT_EXTENDED =>
      val r = HITExtended
      r
    case software.amazon.awssdk.services.mturk.model.EventType.HIT_DISPOSED =>
      val r = HITDisposed
      r
    case software.amazon.awssdk.services.mturk.model.EventType.PING =>
      val r = Ping
      r
  }
  case object unknownToSdkVersion extends zio.aws.mturk.model.EventType {
    override def unwrap: software.amazon.awssdk.services.mturk.model.EventType =
      software.amazon.awssdk.services.mturk.model.EventType.UNKNOWN_TO_SDK_VERSION
  }
  case object AssignmentAccepted extends zio.aws.mturk.model.EventType {
    override def unwrap: software.amazon.awssdk.services.mturk.model.EventType =
      software.amazon.awssdk.services.mturk.model.EventType.ASSIGNMENT_ACCEPTED
  }
  case object AssignmentAbandoned extends zio.aws.mturk.model.EventType {
    override def unwrap: software.amazon.awssdk.services.mturk.model.EventType =
      software.amazon.awssdk.services.mturk.model.EventType.ASSIGNMENT_ABANDONED
  }
  case object AssignmentReturned extends zio.aws.mturk.model.EventType {
    override def unwrap: software.amazon.awssdk.services.mturk.model.EventType =
      software.amazon.awssdk.services.mturk.model.EventType.ASSIGNMENT_RETURNED
  }
  case object AssignmentSubmitted extends zio.aws.mturk.model.EventType {
    override def unwrap: software.amazon.awssdk.services.mturk.model.EventType =
      software.amazon.awssdk.services.mturk.model.EventType.ASSIGNMENT_SUBMITTED
  }
  case object AssignmentRejected extends zio.aws.mturk.model.EventType {
    override def unwrap: software.amazon.awssdk.services.mturk.model.EventType =
      software.amazon.awssdk.services.mturk.model.EventType.ASSIGNMENT_REJECTED
  }
  case object AssignmentApproved extends zio.aws.mturk.model.EventType {
    override def unwrap: software.amazon.awssdk.services.mturk.model.EventType =
      software.amazon.awssdk.services.mturk.model.EventType.ASSIGNMENT_APPROVED
  }
  case object HITCreated extends zio.aws.mturk.model.EventType {
    override def unwrap: software.amazon.awssdk.services.mturk.model.EventType =
      software.amazon.awssdk.services.mturk.model.EventType.HIT_CREATED
  }
  case object HITExpired extends zio.aws.mturk.model.EventType {
    override def unwrap: software.amazon.awssdk.services.mturk.model.EventType =
      software.amazon.awssdk.services.mturk.model.EventType.HIT_EXPIRED
  }
  case object HITReviewable extends zio.aws.mturk.model.EventType {
    override def unwrap: software.amazon.awssdk.services.mturk.model.EventType =
      software.amazon.awssdk.services.mturk.model.EventType.HIT_REVIEWABLE
  }
  case object HITExtended extends zio.aws.mturk.model.EventType {
    override def unwrap: software.amazon.awssdk.services.mturk.model.EventType =
      software.amazon.awssdk.services.mturk.model.EventType.HIT_EXTENDED
  }
  case object HITDisposed extends zio.aws.mturk.model.EventType {
    override def unwrap: software.amazon.awssdk.services.mturk.model.EventType =
      software.amazon.awssdk.services.mturk.model.EventType.HIT_DISPOSED
  }
  case object Ping extends zio.aws.mturk.model.EventType {
    override def unwrap: software.amazon.awssdk.services.mturk.model.EventType =
      software.amazon.awssdk.services.mturk.model.EventType.PING
  }
}
