package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.CurrencyAmount
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetAccountBalanceResponse(
    availableBalance: Optional[CurrencyAmount] = Optional.Absent,
    onHoldBalance: Optional[CurrencyAmount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.GetAccountBalanceResponse = {
    import GetAccountBalanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.GetAccountBalanceResponse
      .builder()
      .optionallyWith(
        availableBalance.map(value =>
          CurrencyAmount.unwrap(value): java.lang.String
        )
      )(_.availableBalance)
      .optionallyWith(
        onHoldBalance.map(value =>
          CurrencyAmount.unwrap(value): java.lang.String
        )
      )(_.onHoldBalance)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.GetAccountBalanceResponse.ReadOnly =
    zio.aws.mturk.model.GetAccountBalanceResponse.wrap(buildAwsValue())
}
object GetAccountBalanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.GetAccountBalanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.GetAccountBalanceResponse =
      zio.aws.mturk.model.GetAccountBalanceResponse(
        availableBalance.map(value => value),
        onHoldBalance.map(value => value)
      )
    def availableBalance: Optional[CurrencyAmount]
    def onHoldBalance: Optional[CurrencyAmount]
    def getAvailableBalance: ZIO[Any, AwsError, CurrencyAmount] =
      AwsError.unwrapOptionField("availableBalance", availableBalance)
    def getOnHoldBalance: ZIO[Any, AwsError, CurrencyAmount] =
      AwsError.unwrapOptionField("onHoldBalance", onHoldBalance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.GetAccountBalanceResponse
  ) extends zio.aws.mturk.model.GetAccountBalanceResponse.ReadOnly {
    override val availableBalance: Optional[CurrencyAmount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availableBalance())
        .map(value => zio.aws.mturk.model.primitives.CurrencyAmount(value))
    override val onHoldBalance: Optional[CurrencyAmount] = zio.aws.core.internal
      .optionalFromNullable(impl.onHoldBalance())
      .map(value => zio.aws.mturk.model.primitives.CurrencyAmount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.GetAccountBalanceResponse
  ): zio.aws.mturk.model.GetAccountBalanceResponse.ReadOnly = new Wrapper(impl)
}
