package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetAssignmentResponse(
    assignment: Optional[zio.aws.mturk.model.Assignment] = Optional.Absent,
    hit: Optional[zio.aws.mturk.model.HIT] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.GetAssignmentResponse = {
    import GetAssignmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.GetAssignmentResponse
      .builder()
      .optionallyWith(assignment.map(value => value.buildAwsValue()))(
        _.assignment
      )
      .optionallyWith(hit.map(value => value.buildAwsValue()))(_.hit)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.GetAssignmentResponse.ReadOnly =
    zio.aws.mturk.model.GetAssignmentResponse.wrap(buildAwsValue())
}
object GetAssignmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.GetAssignmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.GetAssignmentResponse =
      zio.aws.mturk.model.GetAssignmentResponse(
        assignment.map(value => value.asEditable),
        hit.map(value => value.asEditable)
      )
    def assignment: Optional[zio.aws.mturk.model.Assignment.ReadOnly]
    def hit: Optional[zio.aws.mturk.model.HIT.ReadOnly]
    def getAssignment
        : ZIO[Any, AwsError, zio.aws.mturk.model.Assignment.ReadOnly] =
      AwsError.unwrapOptionField("assignment", assignment)
    def getHit: ZIO[Any, AwsError, zio.aws.mturk.model.HIT.ReadOnly] =
      AwsError.unwrapOptionField("hit", hit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.GetAssignmentResponse
  ) extends zio.aws.mturk.model.GetAssignmentResponse.ReadOnly {
    override val assignment: Optional[zio.aws.mturk.model.Assignment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assignment())
        .map(value => zio.aws.mturk.model.Assignment.wrap(value))
    override val hit: Optional[zio.aws.mturk.model.HIT.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hit())
        .map(value => zio.aws.mturk.model.HIT.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.GetAssignmentResponse
  ): zio.aws.mturk.model.GetAssignmentResponse.ReadOnly = new Wrapper(impl)
}
