package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mturk.model.primitives.{CustomerId, EntityId}
import scala.jdk.CollectionConverters._
final case class GetQualificationScoreRequest(
    qualificationTypeId: EntityId,
    workerId: CustomerId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.GetQualificationScoreRequest = {
    import GetQualificationScoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.GetQualificationScoreRequest
      .builder()
      .qualificationTypeId(
        EntityId.unwrap(qualificationTypeId): java.lang.String
      )
      .workerId(CustomerId.unwrap(workerId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.GetQualificationScoreRequest.ReadOnly =
    zio.aws.mturk.model.GetQualificationScoreRequest.wrap(buildAwsValue())
}
object GetQualificationScoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.GetQualificationScoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.GetQualificationScoreRequest =
      zio.aws.mturk.model
        .GetQualificationScoreRequest(qualificationTypeId, workerId)
    def qualificationTypeId: EntityId
    def workerId: CustomerId
    def getQualificationTypeId: ZIO[Any, Nothing, EntityId] =
      ZIO.succeed(qualificationTypeId)
    def getWorkerId: ZIO[Any, Nothing, CustomerId] = ZIO.succeed(workerId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.GetQualificationScoreRequest
  ) extends zio.aws.mturk.model.GetQualificationScoreRequest.ReadOnly {
    override val qualificationTypeId: EntityId =
      zio.aws.mturk.model.primitives.EntityId(impl.qualificationTypeId())
    override val workerId: CustomerId =
      zio.aws.mturk.model.primitives.CustomerId(impl.workerId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.GetQualificationScoreRequest
  ): zio.aws.mturk.model.GetQualificationScoreRequest.ReadOnly = new Wrapper(
    impl
  )
}
