package zio.aws.mturk.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.mturk.model.primitives.{
  CurrencyAmount,
  Integer,
  Timestamp,
  EntityId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class HIT(
    hitId: Optional[EntityId] = Optional.Absent,
    hitTypeId: Optional[EntityId] = Optional.Absent,
    hitGroupId: Optional[EntityId] = Optional.Absent,
    hitLayoutId: Optional[EntityId] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    title: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    question: Optional[String] = Optional.Absent,
    keywords: Optional[String] = Optional.Absent,
    hitStatus: Optional[zio.aws.mturk.model.HITStatus] = Optional.Absent,
    maxAssignments: Optional[Integer] = Optional.Absent,
    reward: Optional[CurrencyAmount] = Optional.Absent,
    autoApprovalDelayInSeconds: Optional[Long] = Optional.Absent,
    expiration: Optional[Timestamp] = Optional.Absent,
    assignmentDurationInSeconds: Optional[Long] = Optional.Absent,
    requesterAnnotation: Optional[String] = Optional.Absent,
    qualificationRequirements: Optional[
      Iterable[zio.aws.mturk.model.QualificationRequirement]
    ] = Optional.Absent,
    hitReviewStatus: Optional[zio.aws.mturk.model.HITReviewStatus] =
      Optional.Absent,
    numberOfAssignmentsPending: Optional[Integer] = Optional.Absent,
    numberOfAssignmentsAvailable: Optional[Integer] = Optional.Absent,
    numberOfAssignmentsCompleted: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.mturk.model.HIT = {
    import HIT.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.HIT
      .builder()
      .optionallyWith(
        hitId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.hitId)
      .optionallyWith(
        hitTypeId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.hitTypeId)
      .optionallyWith(
        hitGroupId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.hitGroupId)
      .optionallyWith(
        hitLayoutId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.hitLayoutId)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(title.map(value => value: java.lang.String))(_.title)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(question.map(value => value: java.lang.String))(
        _.question
      )
      .optionallyWith(keywords.map(value => value: java.lang.String))(
        _.keywords
      )
      .optionallyWith(hitStatus.map(value => value.unwrap))(_.hitStatus)
      .optionallyWith(maxAssignments.map(value => value: java.lang.Integer))(
        _.maxAssignments
      )
      .optionallyWith(
        reward.map(value => CurrencyAmount.unwrap(value): java.lang.String)
      )(_.reward)
      .optionallyWith(
        autoApprovalDelayInSeconds.map(value => value: java.lang.Long)
      )(_.autoApprovalDelayInSeconds)
      .optionallyWith(
        expiration.map(value => Timestamp.unwrap(value): Instant)
      )(_.expiration)
      .optionallyWith(
        assignmentDurationInSeconds.map(value => value: java.lang.Long)
      )(_.assignmentDurationInSeconds)
      .optionallyWith(
        requesterAnnotation.map(value => value: java.lang.String)
      )(_.requesterAnnotation)
      .optionallyWith(
        qualificationRequirements.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.qualificationRequirements)
      .optionallyWith(hitReviewStatus.map(value => value.unwrap))(
        _.hitReviewStatus
      )
      .optionallyWith(
        numberOfAssignmentsPending.map(value => value: java.lang.Integer)
      )(_.numberOfAssignmentsPending)
      .optionallyWith(
        numberOfAssignmentsAvailable.map(value => value: java.lang.Integer)
      )(_.numberOfAssignmentsAvailable)
      .optionallyWith(
        numberOfAssignmentsCompleted.map(value => value: java.lang.Integer)
      )(_.numberOfAssignmentsCompleted)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.HIT.ReadOnly =
    zio.aws.mturk.model.HIT.wrap(buildAwsValue())
}
object HIT {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.mturk.model.HIT] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.HIT = zio.aws.mturk.model.HIT(
      hitId.map(value => value),
      hitTypeId.map(value => value),
      hitGroupId.map(value => value),
      hitLayoutId.map(value => value),
      creationTime.map(value => value),
      title.map(value => value),
      description.map(value => value),
      question.map(value => value),
      keywords.map(value => value),
      hitStatus.map(value => value),
      maxAssignments.map(value => value),
      reward.map(value => value),
      autoApprovalDelayInSeconds.map(value => value),
      expiration.map(value => value),
      assignmentDurationInSeconds.map(value => value),
      requesterAnnotation.map(value => value),
      qualificationRequirements.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      hitReviewStatus.map(value => value),
      numberOfAssignmentsPending.map(value => value),
      numberOfAssignmentsAvailable.map(value => value),
      numberOfAssignmentsCompleted.map(value => value)
    )
    def hitId: Optional[EntityId]
    def hitTypeId: Optional[EntityId]
    def hitGroupId: Optional[EntityId]
    def hitLayoutId: Optional[EntityId]
    def creationTime: Optional[Timestamp]
    def title: Optional[String]
    def description: Optional[String]
    def question: Optional[String]
    def keywords: Optional[String]
    def hitStatus: Optional[zio.aws.mturk.model.HITStatus]
    def maxAssignments: Optional[Integer]
    def reward: Optional[CurrencyAmount]
    def autoApprovalDelayInSeconds: Optional[Long]
    def expiration: Optional[Timestamp]
    def assignmentDurationInSeconds: Optional[Long]
    def requesterAnnotation: Optional[String]
    def qualificationRequirements
        : Optional[List[zio.aws.mturk.model.QualificationRequirement.ReadOnly]]
    def hitReviewStatus: Optional[zio.aws.mturk.model.HITReviewStatus]
    def numberOfAssignmentsPending: Optional[Integer]
    def numberOfAssignmentsAvailable: Optional[Integer]
    def numberOfAssignmentsCompleted: Optional[Integer]
    def getHitId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("hitId", hitId)
    def getHitTypeId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("hitTypeId", hitTypeId)
    def getHitGroupId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("hitGroupId", hitGroupId)
    def getHitLayoutId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("hitLayoutId", hitLayoutId)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getTitle: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("title", title)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getQuestion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("question", question)
    def getKeywords: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keywords", keywords)
    def getHitStatus: ZIO[Any, AwsError, zio.aws.mturk.model.HITStatus] =
      AwsError.unwrapOptionField("hitStatus", hitStatus)
    def getMaxAssignments: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxAssignments", maxAssignments)
    def getReward: ZIO[Any, AwsError, CurrencyAmount] =
      AwsError.unwrapOptionField("reward", reward)
    def getAutoApprovalDelayInSeconds: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "autoApprovalDelayInSeconds",
        autoApprovalDelayInSeconds
      )
    def getExpiration: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expiration", expiration)
    def getAssignmentDurationInSeconds: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "assignmentDurationInSeconds",
        assignmentDurationInSeconds
      )
    def getRequesterAnnotation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("requesterAnnotation", requesterAnnotation)
    def getQualificationRequirements: ZIO[Any, AwsError, List[
      zio.aws.mturk.model.QualificationRequirement.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "qualificationRequirements",
      qualificationRequirements
    )
    def getHitReviewStatus
        : ZIO[Any, AwsError, zio.aws.mturk.model.HITReviewStatus] =
      AwsError.unwrapOptionField("hitReviewStatus", hitReviewStatus)
    def getNumberOfAssignmentsPending: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "numberOfAssignmentsPending",
        numberOfAssignmentsPending
      )
    def getNumberOfAssignmentsAvailable: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "numberOfAssignmentsAvailable",
        numberOfAssignmentsAvailable
      )
    def getNumberOfAssignmentsCompleted: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "numberOfAssignmentsCompleted",
        numberOfAssignmentsCompleted
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.HIT
  ) extends zio.aws.mturk.model.HIT.ReadOnly {
    override val hitId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.hitId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
    override val hitTypeId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.hitTypeId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
    override val hitGroupId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.hitGroupId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
    override val hitLayoutId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.hitLayoutId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.mturk.model.primitives.Timestamp(value))
    override val title: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.title())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val question: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.question())
      .map(value => value: String)
    override val keywords: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.keywords())
      .map(value => value: String)
    override val hitStatus: Optional[zio.aws.mturk.model.HITStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hitStatus())
        .map(value => zio.aws.mturk.model.HITStatus.wrap(value))
    override val maxAssignments: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxAssignments())
      .map(value => value: Integer)
    override val reward: Optional[CurrencyAmount] = zio.aws.core.internal
      .optionalFromNullable(impl.reward())
      .map(value => zio.aws.mturk.model.primitives.CurrencyAmount(value))
    override val autoApprovalDelayInSeconds: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoApprovalDelayInSeconds())
        .map(value => value: Long)
    override val expiration: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.expiration())
      .map(value => zio.aws.mturk.model.primitives.Timestamp(value))
    override val assignmentDurationInSeconds: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assignmentDurationInSeconds())
        .map(value => value: Long)
    override val requesterAnnotation: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.requesterAnnotation())
      .map(value => value: String)
    override val qualificationRequirements: Optional[
      List[zio.aws.mturk.model.QualificationRequirement.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.qualificationRequirements())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mturk.model.QualificationRequirement.wrap(item)
        }.toList
      )
    override val hitReviewStatus
        : Optional[zio.aws.mturk.model.HITReviewStatus] = zio.aws.core.internal
      .optionalFromNullable(impl.hitReviewStatus())
      .map(value => zio.aws.mturk.model.HITReviewStatus.wrap(value))
    override val numberOfAssignmentsPending: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfAssignmentsPending())
        .map(value => value: Integer)
    override val numberOfAssignmentsAvailable: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfAssignmentsAvailable())
        .map(value => value: Integer)
    override val numberOfAssignmentsCompleted: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfAssignmentsCompleted())
        .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.HIT
  ): zio.aws.mturk.model.HIT.ReadOnly = new Wrapper(impl)
}
