package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class HITLayoutParameter(name: String, value: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.HITLayoutParameter = {
    import HITLayoutParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.HITLayoutParameter
      .builder()
      .name(name: java.lang.String)
      .value(value: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.HITLayoutParameter.ReadOnly =
    zio.aws.mturk.model.HITLayoutParameter.wrap(buildAwsValue())
}
object HITLayoutParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.HITLayoutParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.HITLayoutParameter =
      zio.aws.mturk.model.HITLayoutParameter(name, value)
    def name: String
    def value: String
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, String] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.HITLayoutParameter
  ) extends zio.aws.mturk.model.HITLayoutParameter.ReadOnly {
    override val name: String = impl.name(): String
    override val value: String = impl.value(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.HITLayoutParameter
  ): zio.aws.mturk.model.HITLayoutParameter.ReadOnly = new Wrapper(impl)
}
