package zio.aws.mturk.model
import zio.prelude.data.Optional
import zio.aws.mturk.model.primitives.{ResultSize, PaginationToken, EntityId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListBonusPaymentsRequest(
    hitId: Optional[EntityId] = Optional.Absent,
    assignmentId: Optional[EntityId] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[ResultSize] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.ListBonusPaymentsRequest = {
    import ListBonusPaymentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.ListBonusPaymentsRequest
      .builder()
      .optionallyWith(
        hitId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.hitId)
      .optionallyWith(
        assignmentId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.assignmentId)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ResultSize.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.ListBonusPaymentsRequest.ReadOnly =
    zio.aws.mturk.model.ListBonusPaymentsRequest.wrap(buildAwsValue())
}
object ListBonusPaymentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.ListBonusPaymentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.ListBonusPaymentsRequest =
      zio.aws.mturk.model.ListBonusPaymentsRequest(
        hitId.map(value => value),
        assignmentId.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def hitId: Optional[EntityId]
    def assignmentId: Optional[EntityId]
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[ResultSize]
    def getHitId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("hitId", hitId)
    def getAssignmentId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("assignmentId", assignmentId)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ResultSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.ListBonusPaymentsRequest
  ) extends zio.aws.mturk.model.ListBonusPaymentsRequest.ReadOnly {
    override val hitId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.hitId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
    override val assignmentId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.assignmentId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.mturk.model.primitives.PaginationToken(value))
    override val maxResults: Optional[ResultSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.mturk.model.primitives.ResultSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.ListBonusPaymentsRequest
  ): zio.aws.mturk.model.ListBonusPaymentsRequest.ReadOnly = new Wrapper(impl)
}
