package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.{PaginationToken, Integer}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListQualificationRequestsResponse(
    numResults: Optional[Integer] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    qualificationRequests: Optional[
      Iterable[zio.aws.mturk.model.QualificationRequest]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.ListQualificationRequestsResponse = {
    import ListQualificationRequestsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.ListQualificationRequestsResponse
      .builder()
      .optionallyWith(numResults.map(value => value: java.lang.Integer))(
        _.numResults
      )
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        qualificationRequests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.qualificationRequests)
      .build()
  }
  def asReadOnly
      : zio.aws.mturk.model.ListQualificationRequestsResponse.ReadOnly =
    zio.aws.mturk.model.ListQualificationRequestsResponse.wrap(buildAwsValue())
}
object ListQualificationRequestsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.ListQualificationRequestsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.ListQualificationRequestsResponse =
      zio.aws.mturk.model.ListQualificationRequestsResponse(
        numResults.map(value => value),
        nextToken.map(value => value),
        qualificationRequests.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def numResults: Optional[Integer]
    def nextToken: Optional[PaginationToken]
    def qualificationRequests
        : Optional[List[zio.aws.mturk.model.QualificationRequest.ReadOnly]]
    def getNumResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numResults", numResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getQualificationRequests: ZIO[Any, AwsError, List[
      zio.aws.mturk.model.QualificationRequest.ReadOnly
    ]] =
      AwsError.unwrapOptionField("qualificationRequests", qualificationRequests)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.ListQualificationRequestsResponse
  ) extends zio.aws.mturk.model.ListQualificationRequestsResponse.ReadOnly {
    override val numResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.numResults())
      .map(value => value: Integer)
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.mturk.model.primitives.PaginationToken(value))
    override val qualificationRequests
        : Optional[List[zio.aws.mturk.model.QualificationRequest.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.qualificationRequests())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mturk.model.QualificationRequest.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.ListQualificationRequestsResponse
  ): zio.aws.mturk.model.ListQualificationRequestsResponse.ReadOnly =
    new Wrapper(impl)
}
