package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.{PaginationToken, EntityId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListReviewPolicyResultsForHitResponse(
    hitId: Optional[EntityId] = Optional.Absent,
    assignmentReviewPolicy: Optional[zio.aws.mturk.model.ReviewPolicy] =
      Optional.Absent,
    hitReviewPolicy: Optional[zio.aws.mturk.model.ReviewPolicy] =
      Optional.Absent,
    assignmentReviewReport: Optional[zio.aws.mturk.model.ReviewReport] =
      Optional.Absent,
    hitReviewReport: Optional[zio.aws.mturk.model.ReviewReport] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitResponse = {
    import ListReviewPolicyResultsForHitResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitResponse
      .builder()
      .optionallyWith(
        hitId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.hitId)
      .optionallyWith(
        assignmentReviewPolicy.map(value => value.buildAwsValue())
      )(_.assignmentReviewPolicy)
      .optionallyWith(hitReviewPolicy.map(value => value.buildAwsValue()))(
        _.hitReviewPolicy
      )
      .optionallyWith(
        assignmentReviewReport.map(value => value.buildAwsValue())
      )(_.assignmentReviewReport)
      .optionallyWith(hitReviewReport.map(value => value.buildAwsValue()))(
        _.hitReviewReport
      )
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.mturk.model.ListReviewPolicyResultsForHitResponse.ReadOnly =
    zio.aws.mturk.model.ListReviewPolicyResultsForHitResponse
      .wrap(buildAwsValue())
}
object ListReviewPolicyResultsForHitResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.ListReviewPolicyResultsForHitResponse =
      zio.aws.mturk.model.ListReviewPolicyResultsForHitResponse(
        hitId.map(value => value),
        assignmentReviewPolicy.map(value => value.asEditable),
        hitReviewPolicy.map(value => value.asEditable),
        assignmentReviewReport.map(value => value.asEditable),
        hitReviewReport.map(value => value.asEditable),
        nextToken.map(value => value)
      )
    def hitId: Optional[EntityId]
    def assignmentReviewPolicy
        : Optional[zio.aws.mturk.model.ReviewPolicy.ReadOnly]
    def hitReviewPolicy: Optional[zio.aws.mturk.model.ReviewPolicy.ReadOnly]
    def assignmentReviewReport
        : Optional[zio.aws.mturk.model.ReviewReport.ReadOnly]
    def hitReviewReport: Optional[zio.aws.mturk.model.ReviewReport.ReadOnly]
    def nextToken: Optional[PaginationToken]
    def getHitId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("hitId", hitId)
    def getAssignmentReviewPolicy
        : ZIO[Any, AwsError, zio.aws.mturk.model.ReviewPolicy.ReadOnly] =
      AwsError.unwrapOptionField(
        "assignmentReviewPolicy",
        assignmentReviewPolicy
      )
    def getHitReviewPolicy
        : ZIO[Any, AwsError, zio.aws.mturk.model.ReviewPolicy.ReadOnly] =
      AwsError.unwrapOptionField("hitReviewPolicy", hitReviewPolicy)
    def getAssignmentReviewReport
        : ZIO[Any, AwsError, zio.aws.mturk.model.ReviewReport.ReadOnly] =
      AwsError.unwrapOptionField(
        "assignmentReviewReport",
        assignmentReviewReport
      )
    def getHitReviewReport
        : ZIO[Any, AwsError, zio.aws.mturk.model.ReviewReport.ReadOnly] =
      AwsError.unwrapOptionField("hitReviewReport", hitReviewReport)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitResponse
  ) extends zio.aws.mturk.model.ListReviewPolicyResultsForHitResponse.ReadOnly {
    override val hitId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.hitId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
    override val assignmentReviewPolicy
        : Optional[zio.aws.mturk.model.ReviewPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assignmentReviewPolicy())
        .map(value => zio.aws.mturk.model.ReviewPolicy.wrap(value))
    override val hitReviewPolicy
        : Optional[zio.aws.mturk.model.ReviewPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hitReviewPolicy())
        .map(value => zio.aws.mturk.model.ReviewPolicy.wrap(value))
    override val assignmentReviewReport
        : Optional[zio.aws.mturk.model.ReviewReport.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assignmentReviewReport())
        .map(value => zio.aws.mturk.model.ReviewReport.wrap(value))
    override val hitReviewReport
        : Optional[zio.aws.mturk.model.ReviewReport.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hitReviewReport())
        .map(value => zio.aws.mturk.model.ReviewReport.wrap(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.mturk.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitResponse
  ): zio.aws.mturk.model.ListReviewPolicyResultsForHitResponse.ReadOnly =
    new Wrapper(impl)
}
