package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.{Integer, PaginationToken}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListWorkerBlocksResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    numResults: Optional[Integer] = Optional.Absent,
    workerBlocks: Optional[Iterable[zio.aws.mturk.model.WorkerBlock]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.ListWorkerBlocksResponse = {
    import ListWorkerBlocksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.ListWorkerBlocksResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(numResults.map(value => value: java.lang.Integer))(
        _.numResults
      )
      .optionallyWith(
        workerBlocks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.workerBlocks)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.ListWorkerBlocksResponse.ReadOnly =
    zio.aws.mturk.model.ListWorkerBlocksResponse.wrap(buildAwsValue())
}
object ListWorkerBlocksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.ListWorkerBlocksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.ListWorkerBlocksResponse =
      zio.aws.mturk.model.ListWorkerBlocksResponse(
        nextToken.map(value => value),
        numResults.map(value => value),
        workerBlocks.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[PaginationToken]
    def numResults: Optional[Integer]
    def workerBlocks: Optional[List[zio.aws.mturk.model.WorkerBlock.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getNumResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numResults", numResults)
    def getWorkerBlocks
        : ZIO[Any, AwsError, List[zio.aws.mturk.model.WorkerBlock.ReadOnly]] =
      AwsError.unwrapOptionField("workerBlocks", workerBlocks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.ListWorkerBlocksResponse
  ) extends zio.aws.mturk.model.ListWorkerBlocksResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.mturk.model.primitives.PaginationToken(value))
    override val numResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.numResults())
      .map(value => value: Integer)
    override val workerBlocks
        : Optional[List[zio.aws.mturk.model.WorkerBlock.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workerBlocks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mturk.model.WorkerBlock.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.ListWorkerBlocksResponse
  ): zio.aws.mturk.model.ListWorkerBlocksResponse.ReadOnly = new Wrapper(impl)
}
