package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.{Integer, PaginationToken}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListWorkersWithQualificationTypeResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    numResults: Optional[Integer] = Optional.Absent,
    qualifications: Optional[Iterable[zio.aws.mturk.model.Qualification]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeResponse = {
    import ListWorkersWithQualificationTypeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(numResults.map(value => value: java.lang.Integer))(
        _.numResults
      )
      .optionallyWith(
        qualifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.qualifications)
      .build()
  }
  def asReadOnly
      : zio.aws.mturk.model.ListWorkersWithQualificationTypeResponse.ReadOnly =
    zio.aws.mturk.model.ListWorkersWithQualificationTypeResponse
      .wrap(buildAwsValue())
}
object ListWorkersWithQualificationTypeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.mturk.model.ListWorkersWithQualificationTypeResponse =
      zio.aws.mturk.model.ListWorkersWithQualificationTypeResponse(
        nextToken.map(value => value),
        numResults.map(value => value),
        qualifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[PaginationToken]
    def numResults: Optional[Integer]
    def qualifications
        : Optional[List[zio.aws.mturk.model.Qualification.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getNumResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numResults", numResults)
    def getQualifications
        : ZIO[Any, AwsError, List[zio.aws.mturk.model.Qualification.ReadOnly]] =
      AwsError.unwrapOptionField("qualifications", qualifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeResponse
  ) extends zio.aws.mturk.model.ListWorkersWithQualificationTypeResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.mturk.model.primitives.PaginationToken(value))
    override val numResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.numResults())
      .map(value => value: Integer)
    override val qualifications
        : Optional[List[zio.aws.mturk.model.Qualification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.qualifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mturk.model.Qualification.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeResponse
  ): zio.aws.mturk.model.ListWorkersWithQualificationTypeResponse.ReadOnly =
    new Wrapper(impl)
}
