package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ParameterMapEntry(
    key: Optional[String] = Optional.Absent,
    values: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.ParameterMapEntry = {
    import ParameterMapEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.ParameterMapEntry
      .builder()
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.ParameterMapEntry.ReadOnly =
    zio.aws.mturk.model.ParameterMapEntry.wrap(buildAwsValue())
}
object ParameterMapEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.ParameterMapEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.ParameterMapEntry = zio.aws.mturk.model
      .ParameterMapEntry(key.map(value => value), values.map(value => value))
    def key: Optional[String]
    def values: Optional[List[String]]
    def getKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("key", key)
    def getValues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.ParameterMapEntry
  ) extends zio.aws.mturk.model.ParameterMapEntry.ReadOnly {
    override val key: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => value: String)
    override val values: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.values())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.ParameterMapEntry
  ): zio.aws.mturk.model.ParameterMapEntry.ReadOnly = new Wrapper(impl)
}
