package zio.aws.mturk.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.mturk.model.primitives.{Integer, Timestamp, CustomerId, EntityId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Qualification(
    qualificationTypeId: Optional[EntityId] = Optional.Absent,
    workerId: Optional[CustomerId] = Optional.Absent,
    grantTime: Optional[Timestamp] = Optional.Absent,
    integerValue: Optional[Integer] = Optional.Absent,
    localeValue: Optional[zio.aws.mturk.model.Locale] = Optional.Absent,
    status: Optional[zio.aws.mturk.model.QualificationStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.Qualification = {
    import Qualification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.Qualification
      .builder()
      .optionallyWith(
        qualificationTypeId.map(value =>
          EntityId.unwrap(value): java.lang.String
        )
      )(_.qualificationTypeId)
      .optionallyWith(
        workerId.map(value => CustomerId.unwrap(value): java.lang.String)
      )(_.workerId)
      .optionallyWith(grantTime.map(value => Timestamp.unwrap(value): Instant))(
        _.grantTime
      )
      .optionallyWith(integerValue.map(value => value: java.lang.Integer))(
        _.integerValue
      )
      .optionallyWith(localeValue.map(value => value.buildAwsValue()))(
        _.localeValue
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.Qualification.ReadOnly =
    zio.aws.mturk.model.Qualification.wrap(buildAwsValue())
}
object Qualification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.Qualification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.Qualification =
      zio.aws.mturk.model.Qualification(
        qualificationTypeId.map(value => value),
        workerId.map(value => value),
        grantTime.map(value => value),
        integerValue.map(value => value),
        localeValue.map(value => value.asEditable),
        status.map(value => value)
      )
    def qualificationTypeId: Optional[EntityId]
    def workerId: Optional[CustomerId]
    def grantTime: Optional[Timestamp]
    def integerValue: Optional[Integer]
    def localeValue: Optional[zio.aws.mturk.model.Locale.ReadOnly]
    def status: Optional[zio.aws.mturk.model.QualificationStatus]
    def getQualificationTypeId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("qualificationTypeId", qualificationTypeId)
    def getWorkerId: ZIO[Any, AwsError, CustomerId] =
      AwsError.unwrapOptionField("workerId", workerId)
    def getGrantTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("grantTime", grantTime)
    def getIntegerValue: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("integerValue", integerValue)
    def getLocaleValue
        : ZIO[Any, AwsError, zio.aws.mturk.model.Locale.ReadOnly] =
      AwsError.unwrapOptionField("localeValue", localeValue)
    def getStatus: ZIO[Any, AwsError, zio.aws.mturk.model.QualificationStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.Qualification
  ) extends zio.aws.mturk.model.Qualification.ReadOnly {
    override val qualificationTypeId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.qualificationTypeId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
    override val workerId: Optional[CustomerId] = zio.aws.core.internal
      .optionalFromNullable(impl.workerId())
      .map(value => zio.aws.mturk.model.primitives.CustomerId(value))
    override val grantTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.grantTime())
      .map(value => zio.aws.mturk.model.primitives.Timestamp(value))
    override val integerValue: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.integerValue())
      .map(value => value: Integer)
    override val localeValue: Optional[zio.aws.mturk.model.Locale.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localeValue())
        .map(value => zio.aws.mturk.model.Locale.wrap(value))
    override val status: Optional[zio.aws.mturk.model.QualificationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.mturk.model.QualificationStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.Qualification
  ): zio.aws.mturk.model.Qualification.ReadOnly = new Wrapper(impl)
}
