package zio.aws.mturk.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.mturk.model.primitives.{Timestamp, CustomerId, EntityId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class QualificationRequest(
    qualificationRequestId: Optional[String] = Optional.Absent,
    qualificationTypeId: Optional[EntityId] = Optional.Absent,
    workerId: Optional[CustomerId] = Optional.Absent,
    test: Optional[String] = Optional.Absent,
    answer: Optional[String] = Optional.Absent,
    submitTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.QualificationRequest = {
    import QualificationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.QualificationRequest
      .builder()
      .optionallyWith(
        qualificationRequestId.map(value => value: java.lang.String)
      )(_.qualificationRequestId)
      .optionallyWith(
        qualificationTypeId.map(value =>
          EntityId.unwrap(value): java.lang.String
        )
      )(_.qualificationTypeId)
      .optionallyWith(
        workerId.map(value => CustomerId.unwrap(value): java.lang.String)
      )(_.workerId)
      .optionallyWith(test.map(value => value: java.lang.String))(_.test)
      .optionallyWith(answer.map(value => value: java.lang.String))(_.answer)
      .optionallyWith(
        submitTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.submitTime)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.QualificationRequest.ReadOnly =
    zio.aws.mturk.model.QualificationRequest.wrap(buildAwsValue())
}
object QualificationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.QualificationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.QualificationRequest =
      zio.aws.mturk.model.QualificationRequest(
        qualificationRequestId.map(value => value),
        qualificationTypeId.map(value => value),
        workerId.map(value => value),
        test.map(value => value),
        answer.map(value => value),
        submitTime.map(value => value)
      )
    def qualificationRequestId: Optional[String]
    def qualificationTypeId: Optional[EntityId]
    def workerId: Optional[CustomerId]
    def test: Optional[String]
    def answer: Optional[String]
    def submitTime: Optional[Timestamp]
    def getQualificationRequestId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("qualificationRequestId", qualificationRequestId)
    def getQualificationTypeId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("qualificationTypeId", qualificationTypeId)
    def getWorkerId: ZIO[Any, AwsError, CustomerId] =
      AwsError.unwrapOptionField("workerId", workerId)
    def getTest: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("test", test)
    def getAnswer: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("answer", answer)
    def getSubmitTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("submitTime", submitTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.QualificationRequest
  ) extends zio.aws.mturk.model.QualificationRequest.ReadOnly {
    override val qualificationRequestId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.qualificationRequestId())
        .map(value => value: String)
    override val qualificationTypeId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.qualificationTypeId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
    override val workerId: Optional[CustomerId] = zio.aws.core.internal
      .optionalFromNullable(impl.workerId())
      .map(value => zio.aws.mturk.model.primitives.CustomerId(value))
    override val test: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.test())
      .map(value => value: String)
    override val answer: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.answer())
      .map(value => value: String)
    override val submitTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.submitTime())
      .map(value => zio.aws.mturk.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.QualificationRequest
  ): zio.aws.mturk.model.QualificationRequest.ReadOnly = new Wrapper(impl)
}
