package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.Integer
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class QualificationRequirement(
    qualificationTypeId: String,
    comparator: zio.aws.mturk.model.Comparator,
    integerValues: Optional[Iterable[Integer]] = Optional.Absent,
    localeValues: Optional[Iterable[zio.aws.mturk.model.Locale]] =
      Optional.Absent,
    requiredToPreview: Optional[Boolean] = Optional.Absent,
    actionsGuarded: Optional[zio.aws.mturk.model.HITAccessActions] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.QualificationRequirement = {
    import QualificationRequirement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.QualificationRequirement
      .builder()
      .qualificationTypeId(qualificationTypeId: java.lang.String)
      .comparator(comparator.unwrap)
      .optionallyWith(
        integerValues.map(value =>
          value.map { item =>
            item: java.lang.Integer
          }.asJavaCollection
        )
      )(_.integerValues)
      .optionallyWith(
        localeValues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.localeValues)
      .optionallyWith(requiredToPreview.map(value => value: java.lang.Boolean))(
        _.requiredToPreview
      )
      .optionallyWith(actionsGuarded.map(value => value.unwrap))(
        _.actionsGuarded
      )
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.QualificationRequirement.ReadOnly =
    zio.aws.mturk.model.QualificationRequirement.wrap(buildAwsValue())
}
object QualificationRequirement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.QualificationRequirement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.QualificationRequirement =
      zio.aws.mturk.model.QualificationRequirement(
        qualificationTypeId,
        comparator,
        integerValues.map(value => value),
        localeValues.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        requiredToPreview.map(value => value),
        actionsGuarded.map(value => value)
      )
    def qualificationTypeId: String
    def comparator: zio.aws.mturk.model.Comparator
    def integerValues: Optional[List[Integer]]
    def localeValues: Optional[List[zio.aws.mturk.model.Locale.ReadOnly]]
    def requiredToPreview: Optional[Boolean]
    def actionsGuarded: Optional[zio.aws.mturk.model.HITAccessActions]
    def getQualificationTypeId: ZIO[Any, Nothing, String] =
      ZIO.succeed(qualificationTypeId)
    def getComparator: ZIO[Any, Nothing, zio.aws.mturk.model.Comparator] =
      ZIO.succeed(comparator)
    def getIntegerValues: ZIO[Any, AwsError, List[Integer]] =
      AwsError.unwrapOptionField("integerValues", integerValues)
    def getLocaleValues
        : ZIO[Any, AwsError, List[zio.aws.mturk.model.Locale.ReadOnly]] =
      AwsError.unwrapOptionField("localeValues", localeValues)
    def getRequiredToPreview: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("requiredToPreview", requiredToPreview)
    def getActionsGuarded
        : ZIO[Any, AwsError, zio.aws.mturk.model.HITAccessActions] =
      AwsError.unwrapOptionField("actionsGuarded", actionsGuarded)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.QualificationRequirement
  ) extends zio.aws.mturk.model.QualificationRequirement.ReadOnly {
    override val qualificationTypeId: String =
      impl.qualificationTypeId(): String
    override val comparator: zio.aws.mturk.model.Comparator =
      zio.aws.mturk.model.Comparator.wrap(impl.comparator())
    override val integerValues: Optional[List[Integer]] = zio.aws.core.internal
      .optionalFromNullable(impl.integerValues())
      .map(value =>
        value.asScala.map { item =>
          item: Integer
        }.toList
      )
    override val localeValues
        : Optional[List[zio.aws.mturk.model.Locale.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localeValues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mturk.model.Locale.wrap(item)
          }.toList
        )
    override val requiredToPreview: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.requiredToPreview())
      .map(value => value: Boolean)
    override val actionsGuarded
        : Optional[zio.aws.mturk.model.HITAccessActions] = zio.aws.core.internal
      .optionalFromNullable(impl.actionsGuarded())
      .map(value => zio.aws.mturk.model.HITAccessActions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.QualificationRequirement
  ): zio.aws.mturk.model.QualificationRequirement.ReadOnly = new Wrapper(impl)
}
