package zio.aws.mturk.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.mturk.model.primitives.{Timestamp, EntityId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ReviewActionDetail(
    actionId: Optional[EntityId] = Optional.Absent,
    actionName: Optional[String] = Optional.Absent,
    targetId: Optional[EntityId] = Optional.Absent,
    targetType: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.mturk.model.ReviewActionStatus] = Optional.Absent,
    completeTime: Optional[Timestamp] = Optional.Absent,
    result: Optional[String] = Optional.Absent,
    errorCode: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.ReviewActionDetail = {
    import ReviewActionDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.ReviewActionDetail
      .builder()
      .optionallyWith(
        actionId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.actionId)
      .optionallyWith(actionName.map(value => value: java.lang.String))(
        _.actionName
      )
      .optionallyWith(
        targetId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.targetId)
      .optionallyWith(targetType.map(value => value: java.lang.String))(
        _.targetType
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        completeTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.completeTime)
      .optionallyWith(result.map(value => value: java.lang.String))(_.result)
      .optionallyWith(errorCode.map(value => value: java.lang.String))(
        _.errorCode
      )
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.ReviewActionDetail.ReadOnly =
    zio.aws.mturk.model.ReviewActionDetail.wrap(buildAwsValue())
}
object ReviewActionDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.ReviewActionDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.ReviewActionDetail =
      zio.aws.mturk.model.ReviewActionDetail(
        actionId.map(value => value),
        actionName.map(value => value),
        targetId.map(value => value),
        targetType.map(value => value),
        status.map(value => value),
        completeTime.map(value => value),
        result.map(value => value),
        errorCode.map(value => value)
      )
    def actionId: Optional[EntityId]
    def actionName: Optional[String]
    def targetId: Optional[EntityId]
    def targetType: Optional[String]
    def status: Optional[zio.aws.mturk.model.ReviewActionStatus]
    def completeTime: Optional[Timestamp]
    def result: Optional[String]
    def errorCode: Optional[String]
    def getActionId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("actionId", actionId)
    def getActionName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("actionName", actionName)
    def getTargetId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("targetId", targetId)
    def getTargetType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetType", targetType)
    def getStatus: ZIO[Any, AwsError, zio.aws.mturk.model.ReviewActionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCompleteTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("completeTime", completeTime)
    def getResult: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("result", result)
    def getErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorCode", errorCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.ReviewActionDetail
  ) extends zio.aws.mturk.model.ReviewActionDetail.ReadOnly {
    override val actionId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.actionId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
    override val actionName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.actionName())
      .map(value => value: String)
    override val targetId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.targetId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
    override val targetType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.targetType())
      .map(value => value: String)
    override val status: Optional[zio.aws.mturk.model.ReviewActionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.mturk.model.ReviewActionStatus.wrap(value))
    override val completeTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.completeTime())
      .map(value => zio.aws.mturk.model.primitives.Timestamp(value))
    override val result: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.result())
      .map(value => value: String)
    override val errorCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.ReviewActionDetail
  ): zio.aws.mturk.model.ReviewActionDetail.ReadOnly = new Wrapper(impl)
}
