package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.EntityId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReviewResultDetail(
    actionId: Optional[EntityId] = Optional.Absent,
    subjectId: Optional[EntityId] = Optional.Absent,
    subjectType: Optional[String] = Optional.Absent,
    questionId: Optional[EntityId] = Optional.Absent,
    key: Optional[String] = Optional.Absent,
    value: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.ReviewResultDetail = {
    import ReviewResultDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.ReviewResultDetail
      .builder()
      .optionallyWith(
        actionId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.actionId)
      .optionallyWith(
        subjectId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.subjectId)
      .optionallyWith(subjectType.map(value => value: java.lang.String))(
        _.subjectType
      )
      .optionallyWith(
        questionId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.questionId)
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.ReviewResultDetail.ReadOnly =
    zio.aws.mturk.model.ReviewResultDetail.wrap(buildAwsValue())
}
object ReviewResultDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.ReviewResultDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.ReviewResultDetail =
      zio.aws.mturk.model.ReviewResultDetail(
        actionId.map(value => value),
        subjectId.map(value => value),
        subjectType.map(value => value),
        questionId.map(value => value),
        key.map(value => value),
        value.map(value => value)
      )
    def actionId: Optional[EntityId]
    def subjectId: Optional[EntityId]
    def subjectType: Optional[String]
    def questionId: Optional[EntityId]
    def key: Optional[String]
    def value: Optional[String]
    def getActionId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("actionId", actionId)
    def getSubjectId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("subjectId", subjectId)
    def getSubjectType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subjectType", subjectType)
    def getQuestionId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("questionId", questionId)
    def getKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.ReviewResultDetail
  ) extends zio.aws.mturk.model.ReviewResultDetail.ReadOnly {
    override val actionId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.actionId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
    override val subjectId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.subjectId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
    override val subjectType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subjectType())
      .map(value => value: String)
    override val questionId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.questionId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
    override val key: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => value: String)
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.ReviewResultDetail
  ): zio.aws.mturk.model.ReviewResultDetail.ReadOnly = new Wrapper(impl)
}
