package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SendTestEventNotificationRequest(
    notification: zio.aws.mturk.model.NotificationSpecification,
    testEventType: zio.aws.mturk.model.EventType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.SendTestEventNotificationRequest = {
    import SendTestEventNotificationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.SendTestEventNotificationRequest
      .builder()
      .notification(notification.buildAwsValue())
      .testEventType(testEventType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.mturk.model.SendTestEventNotificationRequest.ReadOnly =
    zio.aws.mturk.model.SendTestEventNotificationRequest.wrap(buildAwsValue())
}
object SendTestEventNotificationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.SendTestEventNotificationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.SendTestEventNotificationRequest =
      zio.aws.mturk.model.SendTestEventNotificationRequest(
        notification.asEditable,
        testEventType
      )
    def notification: zio.aws.mturk.model.NotificationSpecification.ReadOnly
    def testEventType: zio.aws.mturk.model.EventType
    def getNotification: ZIO[
      Any,
      Nothing,
      zio.aws.mturk.model.NotificationSpecification.ReadOnly
    ] = ZIO.succeed(notification)
    def getTestEventType: ZIO[Any, Nothing, zio.aws.mturk.model.EventType] =
      ZIO.succeed(testEventType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.SendTestEventNotificationRequest
  ) extends zio.aws.mturk.model.SendTestEventNotificationRequest.ReadOnly {
    override val notification
        : zio.aws.mturk.model.NotificationSpecification.ReadOnly =
      zio.aws.mturk.model.NotificationSpecification.wrap(impl.notification())
    override val testEventType: zio.aws.mturk.model.EventType =
      zio.aws.mturk.model.EventType.wrap(impl.testEventType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.SendTestEventNotificationRequest
  ): zio.aws.mturk.model.SendTestEventNotificationRequest.ReadOnly =
    new Wrapper(impl)
}
