package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mturk.model.primitives.EntityId
import scala.jdk.CollectionConverters._
final case class UpdateHitTypeOfHitRequest(
    hitId: EntityId,
    hitTypeId: EntityId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.UpdateHitTypeOfHitRequest = {
    import UpdateHitTypeOfHitRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.UpdateHitTypeOfHitRequest
      .builder()
      .hitId(EntityId.unwrap(hitId): java.lang.String)
      .hitTypeId(EntityId.unwrap(hitTypeId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.UpdateHitTypeOfHitRequest.ReadOnly =
    zio.aws.mturk.model.UpdateHitTypeOfHitRequest.wrap(buildAwsValue())
}
object UpdateHitTypeOfHitRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.UpdateHitTypeOfHitRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.UpdateHitTypeOfHitRequest =
      zio.aws.mturk.model.UpdateHitTypeOfHitRequest(hitId, hitTypeId)
    def hitId: EntityId
    def hitTypeId: EntityId
    def getHitId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(hitId)
    def getHitTypeId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(hitTypeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.UpdateHitTypeOfHitRequest
  ) extends zio.aws.mturk.model.UpdateHitTypeOfHitRequest.ReadOnly {
    override val hitId: EntityId =
      zio.aws.mturk.model.primitives.EntityId(impl.hitId())
    override val hitTypeId: EntityId =
      zio.aws.mturk.model.primitives.EntityId(impl.hitTypeId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.UpdateHitTypeOfHitRequest
  ): zio.aws.mturk.model.UpdateHitTypeOfHitRequest.ReadOnly = new Wrapper(impl)
}
