package zio.aws.mturk.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.mturk.model.primitives.{Timestamp, CustomerId, EntityId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Assignment(
    assignmentId: Optional[EntityId] = Optional.Absent,
    workerId: Optional[CustomerId] = Optional.Absent,
    hitId: Optional[EntityId] = Optional.Absent,
    assignmentStatus: Optional[zio.aws.mturk.model.AssignmentStatus] =
      Optional.Absent,
    autoApprovalTime: Optional[Timestamp] = Optional.Absent,
    acceptTime: Optional[Timestamp] = Optional.Absent,
    submitTime: Optional[Timestamp] = Optional.Absent,
    approvalTime: Optional[Timestamp] = Optional.Absent,
    rejectionTime: Optional[Timestamp] = Optional.Absent,
    deadline: Optional[Timestamp] = Optional.Absent,
    answer: Optional[String] = Optional.Absent,
    requesterFeedback: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.Assignment = {
    import Assignment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.Assignment
      .builder()
      .optionallyWith(
        assignmentId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.assignmentId)
      .optionallyWith(
        workerId.map(value => CustomerId.unwrap(value): java.lang.String)
      )(_.workerId)
      .optionallyWith(
        hitId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.hitId)
      .optionallyWith(assignmentStatus.map(value => value.unwrap))(
        _.assignmentStatus
      )
      .optionallyWith(
        autoApprovalTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.autoApprovalTime)
      .optionallyWith(
        acceptTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.acceptTime)
      .optionallyWith(
        submitTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.submitTime)
      .optionallyWith(
        approvalTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.approvalTime)
      .optionallyWith(
        rejectionTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.rejectionTime)
      .optionallyWith(deadline.map(value => Timestamp.unwrap(value): Instant))(
        _.deadline
      )
      .optionallyWith(answer.map(value => value: java.lang.String))(_.answer)
      .optionallyWith(requesterFeedback.map(value => value: java.lang.String))(
        _.requesterFeedback
      )
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.Assignment.ReadOnly =
    zio.aws.mturk.model.Assignment.wrap(buildAwsValue())
}
object Assignment {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.mturk.model.Assignment] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.Assignment =
      zio.aws.mturk.model.Assignment(
        assignmentId.map(value => value),
        workerId.map(value => value),
        hitId.map(value => value),
        assignmentStatus.map(value => value),
        autoApprovalTime.map(value => value),
        acceptTime.map(value => value),
        submitTime.map(value => value),
        approvalTime.map(value => value),
        rejectionTime.map(value => value),
        deadline.map(value => value),
        answer.map(value => value),
        requesterFeedback.map(value => value)
      )
    def assignmentId: Optional[EntityId]
    def workerId: Optional[CustomerId]
    def hitId: Optional[EntityId]
    def assignmentStatus: Optional[zio.aws.mturk.model.AssignmentStatus]
    def autoApprovalTime: Optional[Timestamp]
    def acceptTime: Optional[Timestamp]
    def submitTime: Optional[Timestamp]
    def approvalTime: Optional[Timestamp]
    def rejectionTime: Optional[Timestamp]
    def deadline: Optional[Timestamp]
    def answer: Optional[String]
    def requesterFeedback: Optional[String]
    def getAssignmentId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("assignmentId", assignmentId)
    def getWorkerId: ZIO[Any, AwsError, CustomerId] =
      AwsError.unwrapOptionField("workerId", workerId)
    def getHitId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("hitId", hitId)
    def getAssignmentStatus
        : ZIO[Any, AwsError, zio.aws.mturk.model.AssignmentStatus] =
      AwsError.unwrapOptionField("assignmentStatus", assignmentStatus)
    def getAutoApprovalTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("autoApprovalTime", autoApprovalTime)
    def getAcceptTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("acceptTime", acceptTime)
    def getSubmitTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("submitTime", submitTime)
    def getApprovalTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("approvalTime", approvalTime)
    def getRejectionTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("rejectionTime", rejectionTime)
    def getDeadline: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("deadline", deadline)
    def getAnswer: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("answer", answer)
    def getRequesterFeedback: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("requesterFeedback", requesterFeedback)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.Assignment
  ) extends zio.aws.mturk.model.Assignment.ReadOnly {
    override val assignmentId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.assignmentId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
    override val workerId: Optional[CustomerId] = zio.aws.core.internal
      .optionalFromNullable(impl.workerId())
      .map(value => zio.aws.mturk.model.primitives.CustomerId(value))
    override val hitId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.hitId())
      .map(value => zio.aws.mturk.model.primitives.EntityId(value))
    override val assignmentStatus
        : Optional[zio.aws.mturk.model.AssignmentStatus] = zio.aws.core.internal
      .optionalFromNullable(impl.assignmentStatus())
      .map(value => zio.aws.mturk.model.AssignmentStatus.wrap(value))
    override val autoApprovalTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.autoApprovalTime())
      .map(value => zio.aws.mturk.model.primitives.Timestamp(value))
    override val acceptTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.acceptTime())
      .map(value => zio.aws.mturk.model.primitives.Timestamp(value))
    override val submitTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.submitTime())
      .map(value => zio.aws.mturk.model.primitives.Timestamp(value))
    override val approvalTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.approvalTime())
      .map(value => zio.aws.mturk.model.primitives.Timestamp(value))
    override val rejectionTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.rejectionTime())
      .map(value => zio.aws.mturk.model.primitives.Timestamp(value))
    override val deadline: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.deadline())
      .map(value => zio.aws.mturk.model.primitives.Timestamp(value))
    override val answer: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.answer())
      .map(value => value: String)
    override val requesterFeedback: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.requesterFeedback())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.Assignment
  ): zio.aws.mturk.model.Assignment.ReadOnly = new Wrapper(impl)
}
