package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mturk.model.primitives.EntityId
import scala.jdk.CollectionConverters._
final case class DeleteQualificationTypeRequest(qualificationTypeId: EntityId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.DeleteQualificationTypeRequest = {
    import DeleteQualificationTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.DeleteQualificationTypeRequest
      .builder()
      .qualificationTypeId(
        EntityId.unwrap(qualificationTypeId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.DeleteQualificationTypeRequest.ReadOnly =
    zio.aws.mturk.model.DeleteQualificationTypeRequest.wrap(buildAwsValue())
}
object DeleteQualificationTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.DeleteQualificationTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.DeleteQualificationTypeRequest =
      zio.aws.mturk.model.DeleteQualificationTypeRequest(qualificationTypeId)
    def qualificationTypeId: EntityId
    def getQualificationTypeId: ZIO[Any, Nothing, EntityId] =
      ZIO.succeed(qualificationTypeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.DeleteQualificationTypeRequest
  ) extends zio.aws.mturk.model.DeleteQualificationTypeRequest.ReadOnly {
    override val qualificationTypeId: EntityId =
      zio.aws.mturk.model.primitives.EntityId(impl.qualificationTypeId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.DeleteQualificationTypeRequest
  ): zio.aws.mturk.model.DeleteQualificationTypeRequest.ReadOnly = new Wrapper(
    impl
  )
}
