package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mturk.model.primitives.EntityId
import scala.jdk.CollectionConverters._
final case class GetAssignmentRequest(assignmentId: EntityId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.GetAssignmentRequest = {
    import GetAssignmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.GetAssignmentRequest
      .builder()
      .assignmentId(EntityId.unwrap(assignmentId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.GetAssignmentRequest.ReadOnly =
    zio.aws.mturk.model.GetAssignmentRequest.wrap(buildAwsValue())
}
object GetAssignmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.GetAssignmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.GetAssignmentRequest =
      zio.aws.mturk.model.GetAssignmentRequest(assignmentId)
    def assignmentId: EntityId
    def getAssignmentId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(assignmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.GetAssignmentRequest
  ) extends zio.aws.mturk.model.GetAssignmentRequest.ReadOnly {
    override val assignmentId: EntityId =
      zio.aws.mturk.model.primitives.EntityId(impl.assignmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.GetAssignmentRequest
  ): zio.aws.mturk.model.GetAssignmentRequest.ReadOnly = new Wrapper(impl)
}
