package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetHitResponse(
    hit: Optional[zio.aws.mturk.model.HIT] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.GetHitResponse = {
    import GetHitResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.GetHitResponse
      .builder()
      .optionallyWith(hit.map(value => value.buildAwsValue()))(_.hit)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.GetHitResponse.ReadOnly =
    zio.aws.mturk.model.GetHitResponse.wrap(buildAwsValue())
}
object GetHitResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.GetHitResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.GetHitResponse =
      zio.aws.mturk.model.GetHitResponse(hit.map(value => value.asEditable))
    def hit: Optional[zio.aws.mturk.model.HIT.ReadOnly]
    def getHit: ZIO[Any, AwsError, zio.aws.mturk.model.HIT.ReadOnly] =
      AwsError.unwrapOptionField("hit", hit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.GetHitResponse
  ) extends zio.aws.mturk.model.GetHitResponse.ReadOnly {
    override val hit: Optional[zio.aws.mturk.model.HIT.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hit())
        .map(value => zio.aws.mturk.model.HIT.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.GetHitResponse
  ): zio.aws.mturk.model.GetHitResponse.ReadOnly = new Wrapper(impl)
}
