package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetQualificationScoreResponse(
    qualification: Optional[zio.aws.mturk.model.Qualification] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.GetQualificationScoreResponse = {
    import GetQualificationScoreResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.GetQualificationScoreResponse
      .builder()
      .optionallyWith(qualification.map(value => value.buildAwsValue()))(
        _.qualification
      )
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.GetQualificationScoreResponse.ReadOnly =
    zio.aws.mturk.model.GetQualificationScoreResponse.wrap(buildAwsValue())
}
object GetQualificationScoreResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.GetQualificationScoreResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.GetQualificationScoreResponse =
      zio.aws.mturk.model.GetQualificationScoreResponse(
        qualification.map(value => value.asEditable)
      )
    def qualification: Optional[zio.aws.mturk.model.Qualification.ReadOnly]
    def getQualification
        : ZIO[Any, AwsError, zio.aws.mturk.model.Qualification.ReadOnly] =
      AwsError.unwrapOptionField("qualification", qualification)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.GetQualificationScoreResponse
  ) extends zio.aws.mturk.model.GetQualificationScoreResponse.ReadOnly {
    override val qualification
        : Optional[zio.aws.mturk.model.Qualification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.qualification())
        .map(value => zio.aws.mturk.model.Qualification.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.GetQualificationScoreResponse
  ): zio.aws.mturk.model.GetQualificationScoreResponse.ReadOnly = new Wrapper(
    impl
  )
}
