package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mturk.model.primitives.EntityId
import scala.jdk.CollectionConverters._
final case class GetQualificationTypeRequest(qualificationTypeId: EntityId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.GetQualificationTypeRequest = {
    import GetQualificationTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.GetQualificationTypeRequest
      .builder()
      .qualificationTypeId(
        EntityId.unwrap(qualificationTypeId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.GetQualificationTypeRequest.ReadOnly =
    zio.aws.mturk.model.GetQualificationTypeRequest.wrap(buildAwsValue())
}
object GetQualificationTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.GetQualificationTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.GetQualificationTypeRequest =
      zio.aws.mturk.model.GetQualificationTypeRequest(qualificationTypeId)
    def qualificationTypeId: EntityId
    def getQualificationTypeId: ZIO[Any, Nothing, EntityId] =
      ZIO.succeed(qualificationTypeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.GetQualificationTypeRequest
  ) extends zio.aws.mturk.model.GetQualificationTypeRequest.ReadOnly {
    override val qualificationTypeId: EntityId =
      zio.aws.mturk.model.primitives.EntityId(impl.qualificationTypeId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.GetQualificationTypeRequest
  ): zio.aws.mturk.model.GetQualificationTypeRequest.ReadOnly = new Wrapper(
    impl
  )
}
