package zio.aws.mturk.model
import scala.jdk.CollectionConverters._
sealed trait HITStatus {
  def unwrap: software.amazon.awssdk.services.mturk.model.HITStatus
}
object HITStatus {
  def wrap(
      value: software.amazon.awssdk.services.mturk.model.HITStatus
  ): zio.aws.mturk.model.HITStatus = value match {
    case software.amazon.awssdk.services.mturk.model.HITStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mturk.model.HITStatus.ASSIGNABLE =>
      val r = Assignable
      r
    case software.amazon.awssdk.services.mturk.model.HITStatus.UNASSIGNABLE =>
      val r = Unassignable
      r
    case software.amazon.awssdk.services.mturk.model.HITStatus.REVIEWABLE =>
      val r = Reviewable
      r
    case software.amazon.awssdk.services.mturk.model.HITStatus.REVIEWING =>
      val r = Reviewing
      r
    case software.amazon.awssdk.services.mturk.model.HITStatus.DISPOSED =>
      val r = Disposed
      r
  }
  case object unknownToSdkVersion extends zio.aws.mturk.model.HITStatus {
    override def unwrap: software.amazon.awssdk.services.mturk.model.HITStatus =
      software.amazon.awssdk.services.mturk.model.HITStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Assignable extends zio.aws.mturk.model.HITStatus {
    override def unwrap: software.amazon.awssdk.services.mturk.model.HITStatus =
      software.amazon.awssdk.services.mturk.model.HITStatus.ASSIGNABLE
  }
  case object Unassignable extends zio.aws.mturk.model.HITStatus {
    override def unwrap: software.amazon.awssdk.services.mturk.model.HITStatus =
      software.amazon.awssdk.services.mturk.model.HITStatus.UNASSIGNABLE
  }
  case object Reviewable extends zio.aws.mturk.model.HITStatus {
    override def unwrap: software.amazon.awssdk.services.mturk.model.HITStatus =
      software.amazon.awssdk.services.mturk.model.HITStatus.REVIEWABLE
  }
  case object Reviewing extends zio.aws.mturk.model.HITStatus {
    override def unwrap: software.amazon.awssdk.services.mturk.model.HITStatus =
      software.amazon.awssdk.services.mturk.model.HITStatus.REVIEWING
  }
  case object Disposed extends zio.aws.mturk.model.HITStatus {
    override def unwrap: software.amazon.awssdk.services.mturk.model.HITStatus =
      software.amazon.awssdk.services.mturk.model.HITStatus.DISPOSED
  }
}
