package zio.aws.mturk.model
import zio.prelude.data.Optional
import zio.aws.mturk.model.primitives.{ResultSize, PaginationToken, EntityId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListHiTsForQualificationTypeRequest(
    qualificationTypeId: EntityId,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[ResultSize] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.ListHiTsForQualificationTypeRequest = {
    import ListHiTsForQualificationTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.ListHiTsForQualificationTypeRequest
      .builder()
      .qualificationTypeId(
        EntityId.unwrap(qualificationTypeId): java.lang.String
      )
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ResultSize.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.mturk.model.ListHiTsForQualificationTypeRequest.ReadOnly =
    zio.aws.mturk.model.ListHiTsForQualificationTypeRequest
      .wrap(buildAwsValue())
}
object ListHiTsForQualificationTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.ListHiTsForQualificationTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.ListHiTsForQualificationTypeRequest =
      zio.aws.mturk.model.ListHiTsForQualificationTypeRequest(
        qualificationTypeId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def qualificationTypeId: EntityId
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[ResultSize]
    def getQualificationTypeId: ZIO[Any, Nothing, EntityId] =
      ZIO.succeed(qualificationTypeId)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ResultSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.ListHiTsForQualificationTypeRequest
  ) extends zio.aws.mturk.model.ListHiTsForQualificationTypeRequest.ReadOnly {
    override val qualificationTypeId: EntityId =
      zio.aws.mturk.model.primitives.EntityId(impl.qualificationTypeId())
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.mturk.model.primitives.PaginationToken(value))
    override val maxResults: Optional[ResultSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.mturk.model.primitives.ResultSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.ListHiTsForQualificationTypeRequest
  ): zio.aws.mturk.model.ListHiTsForQualificationTypeRequest.ReadOnly =
    new Wrapper(impl)
}
