package zio.aws.mturk.model
import zio.prelude.data.Optional
import zio.aws.mturk.model.primitives.{ResultSize, PaginationToken}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListQualificationTypesRequest(
    query: Optional[String] = Optional.Absent,
    mustBeRequestable: Boolean,
    mustBeOwnedByCaller: Optional[Boolean] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[ResultSize] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.ListQualificationTypesRequest = {
    import ListQualificationTypesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.ListQualificationTypesRequest
      .builder()
      .optionallyWith(query.map(value => value: java.lang.String))(_.query)
      .mustBeRequestable(mustBeRequestable: java.lang.Boolean)
      .optionallyWith(
        mustBeOwnedByCaller.map(value => value: java.lang.Boolean)
      )(_.mustBeOwnedByCaller)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ResultSize.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.ListQualificationTypesRequest.ReadOnly =
    zio.aws.mturk.model.ListQualificationTypesRequest.wrap(buildAwsValue())
}
object ListQualificationTypesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.ListQualificationTypesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.ListQualificationTypesRequest =
      zio.aws.mturk.model.ListQualificationTypesRequest(
        query.map(value => value),
        mustBeRequestable,
        mustBeOwnedByCaller.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def query: Optional[String]
    def mustBeRequestable: Boolean
    def mustBeOwnedByCaller: Optional[Boolean]
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[ResultSize]
    def getQuery: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("query", query)
    def getMustBeRequestable: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(mustBeRequestable)
    def getMustBeOwnedByCaller: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("mustBeOwnedByCaller", mustBeOwnedByCaller)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ResultSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.ListQualificationTypesRequest
  ) extends zio.aws.mturk.model.ListQualificationTypesRequest.ReadOnly {
    override val query: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.query())
      .map(value => value: String)
    override val mustBeRequestable: Boolean = impl.mustBeRequestable(): Boolean
    override val mustBeOwnedByCaller: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.mustBeOwnedByCaller())
      .map(value => value: Boolean)
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.mturk.model.primitives.PaginationToken(value))
    override val maxResults: Optional[ResultSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.mturk.model.primitives.ResultSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.ListQualificationTypesRequest
  ): zio.aws.mturk.model.ListQualificationTypesRequest.ReadOnly = new Wrapper(
    impl
  )
}
