package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mturk.model.primitives.CountryParameters
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Locale(
    country: CountryParameters,
    subdivision: Optional[CountryParameters] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.mturk.model.Locale = {
    import Locale.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.Locale
      .builder()
      .country(CountryParameters.unwrap(country): java.lang.String)
      .optionallyWith(
        subdivision.map(value =>
          CountryParameters.unwrap(value): java.lang.String
        )
      )(_.subdivision)
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.Locale.ReadOnly =
    zio.aws.mturk.model.Locale.wrap(buildAwsValue())
}
object Locale {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.mturk.model.Locale] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.Locale =
      zio.aws.mturk.model.Locale(country, subdivision.map(value => value))
    def country: CountryParameters
    def subdivision: Optional[CountryParameters]
    def getCountry: ZIO[Any, Nothing, CountryParameters] = ZIO.succeed(country)
    def getSubdivision: ZIO[Any, AwsError, CountryParameters] =
      AwsError.unwrapOptionField("subdivision", subdivision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.Locale
  ) extends zio.aws.mturk.model.Locale.ReadOnly {
    override val country: CountryParameters =
      zio.aws.mturk.model.primitives.CountryParameters(impl.country())
    override val subdivision: Optional[CountryParameters] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subdivision())
        .map(value => zio.aws.mturk.model.primitives.CountryParameters(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.Locale
  ): zio.aws.mturk.model.Locale.ReadOnly = new Wrapper(impl)
}
