package zio.aws.mturk.model
import scala.jdk.CollectionConverters._
sealed trait NotifyWorkersFailureCode {
  def unwrap
      : software.amazon.awssdk.services.mturk.model.NotifyWorkersFailureCode
}
object NotifyWorkersFailureCode {
  def wrap(
      value: software.amazon.awssdk.services.mturk.model.NotifyWorkersFailureCode
  ): zio.aws.mturk.model.NotifyWorkersFailureCode = value match {
    case software.amazon.awssdk.services.mturk.model.NotifyWorkersFailureCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mturk.model.NotifyWorkersFailureCode.SOFT_FAILURE =>
      val r = SoftFailure
      r
    case software.amazon.awssdk.services.mturk.model.NotifyWorkersFailureCode.HARD_FAILURE =>
      val r = HardFailure
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mturk.model.NotifyWorkersFailureCode {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.NotifyWorkersFailureCode =
      software.amazon.awssdk.services.mturk.model.NotifyWorkersFailureCode.UNKNOWN_TO_SDK_VERSION
  }
  case object SoftFailure extends zio.aws.mturk.model.NotifyWorkersFailureCode {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.NotifyWorkersFailureCode =
      software.amazon.awssdk.services.mturk.model.NotifyWorkersFailureCode.SOFT_FAILURE
  }
  case object HardFailure extends zio.aws.mturk.model.NotifyWorkersFailureCode {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.NotifyWorkersFailureCode =
      software.amazon.awssdk.services.mturk.model.NotifyWorkersFailureCode.HARD_FAILURE
  }
}
