package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RejectQualificationRequestRequest(
    qualificationRequestId: String,
    reason: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.RejectQualificationRequestRequest = {
    import RejectQualificationRequestRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.RejectQualificationRequestRequest
      .builder()
      .qualificationRequestId(qualificationRequestId: java.lang.String)
      .optionallyWith(reason.map(value => value: java.lang.String))(_.reason)
      .build()
  }
  def asReadOnly
      : zio.aws.mturk.model.RejectQualificationRequestRequest.ReadOnly =
    zio.aws.mturk.model.RejectQualificationRequestRequest.wrap(buildAwsValue())
}
object RejectQualificationRequestRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.RejectQualificationRequestRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.RejectQualificationRequestRequest =
      zio.aws.mturk.model.RejectQualificationRequestRequest(
        qualificationRequestId,
        reason.map(value => value)
      )
    def qualificationRequestId: String
    def reason: Optional[String]
    def getQualificationRequestId: ZIO[Any, Nothing, String] =
      ZIO.succeed(qualificationRequestId)
    def getReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.RejectQualificationRequestRequest
  ) extends zio.aws.mturk.model.RejectQualificationRequestRequest.ReadOnly {
    override val qualificationRequestId: String =
      impl.qualificationRequestId(): String
    override val reason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.RejectQualificationRequestRequest
  ): zio.aws.mturk.model.RejectQualificationRequestRequest.ReadOnly =
    new Wrapper(impl)
}
