package zio.aws.mturk.model
import scala.jdk.CollectionConverters._
sealed trait ReviewActionStatus {
  def unwrap: software.amazon.awssdk.services.mturk.model.ReviewActionStatus
}
object ReviewActionStatus {
  def wrap(
      value: software.amazon.awssdk.services.mturk.model.ReviewActionStatus
  ): zio.aws.mturk.model.ReviewActionStatus = value match {
    case software.amazon.awssdk.services.mturk.model.ReviewActionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mturk.model.ReviewActionStatus.INTENDED =>
      val r = Intended
      r
    case software.amazon.awssdk.services.mturk.model.ReviewActionStatus.SUCCEEDED =>
      val r = Succeeded
      r
    case software.amazon.awssdk.services.mturk.model.ReviewActionStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.mturk.model.ReviewActionStatus.CANCELLED =>
      val r = Cancelled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mturk.model.ReviewActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.ReviewActionStatus =
      software.amazon.awssdk.services.mturk.model.ReviewActionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Intended extends zio.aws.mturk.model.ReviewActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.ReviewActionStatus =
      software.amazon.awssdk.services.mturk.model.ReviewActionStatus.INTENDED
  }
  case object Succeeded extends zio.aws.mturk.model.ReviewActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.ReviewActionStatus =
      software.amazon.awssdk.services.mturk.model.ReviewActionStatus.SUCCEEDED
  }
  case object Failed extends zio.aws.mturk.model.ReviewActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.ReviewActionStatus =
      software.amazon.awssdk.services.mturk.model.ReviewActionStatus.FAILED
  }
  case object Cancelled extends zio.aws.mturk.model.ReviewActionStatus {
    override def unwrap
        : software.amazon.awssdk.services.mturk.model.ReviewActionStatus =
      software.amazon.awssdk.services.mturk.model.ReviewActionStatus.CANCELLED
  }
}
