package zio.aws.mturk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateQualificationTypeResponse(
    qualificationType: Optional[zio.aws.mturk.model.QualificationType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mturk.model.UpdateQualificationTypeResponse = {
    import UpdateQualificationTypeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mturk.model.UpdateQualificationTypeResponse
      .builder()
      .optionallyWith(qualificationType.map(value => value.buildAwsValue()))(
        _.qualificationType
      )
      .build()
  }
  def asReadOnly: zio.aws.mturk.model.UpdateQualificationTypeResponse.ReadOnly =
    zio.aws.mturk.model.UpdateQualificationTypeResponse.wrap(buildAwsValue())
}
object UpdateQualificationTypeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mturk.model.UpdateQualificationTypeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mturk.model.UpdateQualificationTypeResponse =
      zio.aws.mturk.model.UpdateQualificationTypeResponse(
        qualificationType.map(value => value.asEditable)
      )
    def qualificationType
        : Optional[zio.aws.mturk.model.QualificationType.ReadOnly]
    def getQualificationType
        : ZIO[Any, AwsError, zio.aws.mturk.model.QualificationType.ReadOnly] =
      AwsError.unwrapOptionField("qualificationType", qualificationType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mturk.model.UpdateQualificationTypeResponse
  ) extends zio.aws.mturk.model.UpdateQualificationTypeResponse.ReadOnly {
    override val qualificationType
        : Optional[zio.aws.mturk.model.QualificationType.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.qualificationType())
        .map(value => zio.aws.mturk.model.QualificationType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mturk.model.UpdateQualificationTypeResponse
  ): zio.aws.mturk.model.UpdateQualificationTypeResponse.ReadOnly = new Wrapper(
    impl
  )
}
