package zio.aws.mwaa
import zio.aws.mwaa.model.UpdateEnvironmentResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.mwaa.model.{
  CreateWebLoginTokenResponse,
  GetEnvironmentRequest,
  ListEnvironmentsRequest,
  GetEnvironmentResponse,
  UpdateEnvironmentRequest,
  ListTagsForResourceRequest,
  CreateCliTokenRequest,
  UpdateEnvironmentResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  CreateCliTokenResponse,
  UntagResourceRequest,
  CreateEnvironmentRequest,
  DeleteEnvironmentRequest,
  CreateWebLoginTokenRequest,
  TagResourceResponse,
  PublishMetricsResponse,
  ListEnvironmentsResponse,
  CreateEnvironmentResponse,
  TagResourceRequest,
  DeleteEnvironmentResponse,
  PublishMetricsRequest
}
import zio.aws.mwaa.model.primitives.EnvironmentName
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.stream.ZStream
import software.amazon.awssdk.services.mwaa.{
  MwaaAsyncClientBuilder,
  MwaaAsyncClient
}
import scala.jdk.CollectionConverters.*
trait Mwaa extends AspectSupport[Mwaa] {
  val api: MwaaAsyncClient
  def deleteEnvironment(
      request: zio.aws.mwaa.model.DeleteEnvironmentRequest
  ): IO[AwsError, zio.aws.mwaa.model.DeleteEnvironmentResponse.ReadOnly]
  def publishMetrics(
      request: zio.aws.mwaa.model.PublishMetricsRequest
  ): IO[AwsError, zio.aws.mwaa.model.PublishMetricsResponse.ReadOnly]
  def createEnvironment(
      request: zio.aws.mwaa.model.CreateEnvironmentRequest
  ): IO[AwsError, zio.aws.mwaa.model.CreateEnvironmentResponse.ReadOnly]
  def getEnvironment(
      request: zio.aws.mwaa.model.GetEnvironmentRequest
  ): IO[AwsError, zio.aws.mwaa.model.GetEnvironmentResponse.ReadOnly]
  def listEnvironments(
      request: zio.aws.mwaa.model.ListEnvironmentsRequest
  ): ZStream[Any, AwsError, EnvironmentName]
  def listEnvironmentsPaginated(
      request: zio.aws.mwaa.model.ListEnvironmentsRequest
  ): IO[AwsError, zio.aws.mwaa.model.ListEnvironmentsResponse.ReadOnly]
  def untagResource(
      request: zio.aws.mwaa.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.mwaa.model.UntagResourceResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.mwaa.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.mwaa.model.ListTagsForResourceResponse.ReadOnly]
  def tagResource(
      request: zio.aws.mwaa.model.TagResourceRequest
  ): IO[AwsError, zio.aws.mwaa.model.TagResourceResponse.ReadOnly]
  def updateEnvironment(
      request: zio.aws.mwaa.model.UpdateEnvironmentRequest
  ): IO[AwsError, ReadOnly]
  def createCliToken(
      request: zio.aws.mwaa.model.CreateCliTokenRequest
  ): IO[AwsError, zio.aws.mwaa.model.CreateCliTokenResponse.ReadOnly]
  def createWebLoginToken(
      request: zio.aws.mwaa.model.CreateWebLoginTokenRequest
  ): IO[AwsError, zio.aws.mwaa.model.CreateWebLoginTokenResponse.ReadOnly]
}
object Mwaa {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Mwaa] = customized(identity)
  def customized(
      customization: MwaaAsyncClientBuilder => MwaaAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Mwaa] = managed(
    customization
  ).toLayer
  def managed(
      customization: MwaaAsyncClientBuilder => MwaaAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Mwaa] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = MwaaAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[MwaaAsyncClient, MwaaAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[MwaaAsyncClient, MwaaAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new MwaaImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class MwaaImpl[R](
      override val api: MwaaAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Mwaa
      with AwsServiceBase[R] {
    override val serviceName: String = "Mwaa"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): MwaaImpl[R1] = new MwaaImpl(api, newAspect, r)
    def deleteEnvironment(
        request: zio.aws.mwaa.model.DeleteEnvironmentRequest
    ): IO[AwsError, zio.aws.mwaa.model.DeleteEnvironmentResponse.ReadOnly] =
      asyncRequestResponse[DeleteEnvironmentRequest, DeleteEnvironmentResponse](
        "deleteEnvironment",
        api.deleteEnvironment
      )(request.buildAwsValue())
        .map(zio.aws.mwaa.model.DeleteEnvironmentResponse.wrap)
        .provideEnvironment(r)
    def publishMetrics(
        request: zio.aws.mwaa.model.PublishMetricsRequest
    ): IO[AwsError, zio.aws.mwaa.model.PublishMetricsResponse.ReadOnly] =
      asyncRequestResponse[PublishMetricsRequest, PublishMetricsResponse](
        "publishMetrics",
        api.publishMetrics
      )(request.buildAwsValue())
        .map(zio.aws.mwaa.model.PublishMetricsResponse.wrap)
        .provideEnvironment(r)
    def createEnvironment(
        request: zio.aws.mwaa.model.CreateEnvironmentRequest
    ): IO[AwsError, zio.aws.mwaa.model.CreateEnvironmentResponse.ReadOnly] =
      asyncRequestResponse[CreateEnvironmentRequest, CreateEnvironmentResponse](
        "createEnvironment",
        api.createEnvironment
      )(request.buildAwsValue())
        .map(zio.aws.mwaa.model.CreateEnvironmentResponse.wrap)
        .provideEnvironment(r)
    def getEnvironment(
        request: zio.aws.mwaa.model.GetEnvironmentRequest
    ): IO[AwsError, zio.aws.mwaa.model.GetEnvironmentResponse.ReadOnly] =
      asyncRequestResponse[GetEnvironmentRequest, GetEnvironmentResponse](
        "getEnvironment",
        api.getEnvironment
      )(request.buildAwsValue())
        .map(zio.aws.mwaa.model.GetEnvironmentResponse.wrap)
        .provideEnvironment(r)
    def listEnvironments(
        request: zio.aws.mwaa.model.ListEnvironmentsRequest
    ): ZStream[Any, AwsError, EnvironmentName] = asyncSimplePaginatedRequest[
      ListEnvironmentsRequest,
      ListEnvironmentsResponse,
      java.lang.String
    ](
      "listEnvironments",
      api.listEnvironments,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.environments().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.mwaa.model.primitives.EnvironmentName(item))
      .provideEnvironment(r)
    def listEnvironmentsPaginated(
        request: zio.aws.mwaa.model.ListEnvironmentsRequest
    ): IO[AwsError, zio.aws.mwaa.model.ListEnvironmentsResponse.ReadOnly] =
      asyncRequestResponse[ListEnvironmentsRequest, ListEnvironmentsResponse](
        "listEnvironments",
        api.listEnvironments
      )(request.buildAwsValue())
        .map(zio.aws.mwaa.model.ListEnvironmentsResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.mwaa.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.mwaa.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.mwaa.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.mwaa.model.ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.mwaa.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.mwaa.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: zio.aws.mwaa.model.TagResourceRequest
    ): IO[AwsError, zio.aws.mwaa.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.mwaa.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def updateEnvironment(
        request: zio.aws.mwaa.model.UpdateEnvironmentRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[UpdateEnvironmentRequest, UpdateEnvironmentResponse](
        "updateEnvironment",
        api.updateEnvironment
      )(request.buildAwsValue())
        .map(zio.aws.mwaa.model.UpdateEnvironmentResponse.wrap)
        .provideEnvironment(r)
    def createCliToken(
        request: zio.aws.mwaa.model.CreateCliTokenRequest
    ): IO[AwsError, zio.aws.mwaa.model.CreateCliTokenResponse.ReadOnly] =
      asyncRequestResponse[CreateCliTokenRequest, CreateCliTokenResponse](
        "createCliToken",
        api.createCliToken
      )(request.buildAwsValue())
        .map(zio.aws.mwaa.model.CreateCliTokenResponse.wrap)
        .provideEnvironment(r)
    def createWebLoginToken(
        request: zio.aws.mwaa.model.CreateWebLoginTokenRequest
    ): IO[AwsError, zio.aws.mwaa.model.CreateWebLoginTokenResponse.ReadOnly] =
      asyncRequestResponse[
        CreateWebLoginTokenRequest,
        CreateWebLoginTokenResponse
      ]("createWebLoginToken", api.createWebLoginToken)(request.buildAwsValue())
        .map(zio.aws.mwaa.model.CreateWebLoginTokenResponse.wrap)
        .provideEnvironment(r)
  }
  def deleteEnvironment(
      request: zio.aws.mwaa.model.DeleteEnvironmentRequest
  ): ZIO[
    zio.aws.mwaa.Mwaa,
    AwsError,
    zio.aws.mwaa.model.DeleteEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEnvironment(request))
  def publishMetrics(request: zio.aws.mwaa.model.PublishMetricsRequest): ZIO[
    zio.aws.mwaa.Mwaa,
    AwsError,
    zio.aws.mwaa.model.PublishMetricsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.publishMetrics(request))
  def createEnvironment(
      request: zio.aws.mwaa.model.CreateEnvironmentRequest
  ): ZIO[
    zio.aws.mwaa.Mwaa,
    AwsError,
    zio.aws.mwaa.model.CreateEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEnvironment(request))
  def getEnvironment(request: zio.aws.mwaa.model.GetEnvironmentRequest): ZIO[
    zio.aws.mwaa.Mwaa,
    AwsError,
    zio.aws.mwaa.model.GetEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEnvironment(request))
  def listEnvironments(
      request: zio.aws.mwaa.model.ListEnvironmentsRequest
  ): ZStream[zio.aws.mwaa.Mwaa, AwsError, EnvironmentName] =
    ZStream.serviceWithStream(_.listEnvironments(request))
  def listEnvironmentsPaginated(
      request: zio.aws.mwaa.model.ListEnvironmentsRequest
  ): ZIO[
    zio.aws.mwaa.Mwaa,
    AwsError,
    zio.aws.mwaa.model.ListEnvironmentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEnvironmentsPaginated(request))
  def untagResource(request: zio.aws.mwaa.model.UntagResourceRequest): ZIO[
    zio.aws.mwaa.Mwaa,
    AwsError,
    zio.aws.mwaa.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listTagsForResource(
      request: zio.aws.mwaa.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.mwaa.Mwaa,
    AwsError,
    zio.aws.mwaa.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: zio.aws.mwaa.model.TagResourceRequest): ZIO[
    zio.aws.mwaa.Mwaa,
    AwsError,
    zio.aws.mwaa.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def updateEnvironment(
      request: zio.aws.mwaa.model.UpdateEnvironmentRequest
  ): ZIO[zio.aws.mwaa.Mwaa, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.updateEnvironment(request))
  def createCliToken(request: zio.aws.mwaa.model.CreateCliTokenRequest): ZIO[
    zio.aws.mwaa.Mwaa,
    AwsError,
    zio.aws.mwaa.model.CreateCliTokenResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCliToken(request))
  def createWebLoginToken(
      request: zio.aws.mwaa.model.CreateWebLoginTokenRequest
  ): ZIO[
    zio.aws.mwaa.Mwaa,
    AwsError,
    zio.aws.mwaa.model.CreateWebLoginTokenResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWebLoginToken(request))
}
