package zio.aws.mwaa
import zio.aws.mwaa.model.UpdateEnvironmentResponse.ReadOnly
import zio.aws.mwaa.model.{
  GetEnvironmentRequest,
  ListEnvironmentsRequest,
  UpdateEnvironmentRequest,
  ListTagsForResourceRequest,
  CreateCliTokenRequest,
  UntagResourceRequest,
  CreateEnvironmentRequest,
  DeleteEnvironmentRequest,
  CreateWebLoginTokenRequest,
  TagResourceRequest,
  PublishMetricsRequest
}
import zio.aws.mwaa.model.primitives.EnvironmentName
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import software.amazon.awssdk.services.mwaa.MwaaAsyncClient
import zio.test.mock.{Proxy, Mock}
object MwaaMock extends Mock[Mwaa] {
  object DeleteEnvironment
      extends Effect[
        DeleteEnvironmentRequest,
        AwsError,
        zio.aws.mwaa.model.DeleteEnvironmentResponse.ReadOnly
      ]
  object PublishMetrics
      extends Effect[
        PublishMetricsRequest,
        AwsError,
        zio.aws.mwaa.model.PublishMetricsResponse.ReadOnly
      ]
  object CreateEnvironment
      extends Effect[
        CreateEnvironmentRequest,
        AwsError,
        zio.aws.mwaa.model.CreateEnvironmentResponse.ReadOnly
      ]
  object GetEnvironment
      extends Effect[
        GetEnvironmentRequest,
        AwsError,
        zio.aws.mwaa.model.GetEnvironmentResponse.ReadOnly
      ]
  object ListEnvironments
      extends Stream[ListEnvironmentsRequest, AwsError, EnvironmentName]
  object ListEnvironmentsPaginated
      extends Effect[
        ListEnvironmentsRequest,
        AwsError,
        zio.aws.mwaa.model.ListEnvironmentsResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.mwaa.model.UntagResourceResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.mwaa.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.mwaa.model.TagResourceResponse.ReadOnly
      ]
  object UpdateEnvironment
      extends Effect[UpdateEnvironmentRequest, AwsError, ReadOnly]
  object CreateCliToken
      extends Effect[
        CreateCliTokenRequest,
        AwsError,
        zio.aws.mwaa.model.CreateCliTokenResponse.ReadOnly
      ]
  object CreateWebLoginToken
      extends Effect[
        CreateWebLoginTokenRequest,
        AwsError,
        zio.aws.mwaa.model.CreateWebLoginTokenResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Mwaa] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Mwaa {
          val api: MwaaAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Mwaa = this
          def deleteEnvironment(request: DeleteEnvironmentRequest): IO[
            AwsError,
            zio.aws.mwaa.model.DeleteEnvironmentResponse.ReadOnly
          ] = proxy(DeleteEnvironment, request)
          def publishMetrics(
              request: PublishMetricsRequest
          ): IO[AwsError, zio.aws.mwaa.model.PublishMetricsResponse.ReadOnly] =
            proxy(PublishMetrics, request)
          def createEnvironment(request: CreateEnvironmentRequest): IO[
            AwsError,
            zio.aws.mwaa.model.CreateEnvironmentResponse.ReadOnly
          ] = proxy(CreateEnvironment, request)
          def getEnvironment(
              request: GetEnvironmentRequest
          ): IO[AwsError, zio.aws.mwaa.model.GetEnvironmentResponse.ReadOnly] =
            proxy(GetEnvironment, request)
          def listEnvironments(
              request: ListEnvironmentsRequest
          ): ZStream[Any, AwsError, EnvironmentName] =
            rts.unsafeRun(proxy(ListEnvironments, request))
          def listEnvironmentsPaginated(request: ListEnvironmentsRequest): IO[
            AwsError,
            zio.aws.mwaa.model.ListEnvironmentsResponse.ReadOnly
          ] = proxy(ListEnvironmentsPaginated, request)
          def untagResource(
              request: UntagResourceRequest
          ): IO[AwsError, zio.aws.mwaa.model.UntagResourceResponse.ReadOnly] =
            proxy(UntagResource, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.mwaa.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def tagResource(
              request: TagResourceRequest
          ): IO[AwsError, zio.aws.mwaa.model.TagResourceResponse.ReadOnly] =
            proxy(TagResource, request)
          def updateEnvironment(
              request: UpdateEnvironmentRequest
          ): IO[AwsError, ReadOnly] = proxy(UpdateEnvironment, request)
          def createCliToken(
              request: CreateCliTokenRequest
          ): IO[AwsError, zio.aws.mwaa.model.CreateCliTokenResponse.ReadOnly] =
            proxy(CreateCliToken, request)
          def createWebLoginToken(request: CreateWebLoginTokenRequest): IO[
            AwsError,
            zio.aws.mwaa.model.CreateWebLoginTokenResponse.ReadOnly
          ] = proxy(CreateWebLoginToken, request)
        }
      }
    }
    .toLayer
}
