package zio.aws.mwaa.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mwaa.model.primitives.EnvironmentName
import scala.jdk.CollectionConverters.*
final case class CreateCliTokenRequest(name: EnvironmentName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mwaa.model.CreateCliTokenRequest = {
    import CreateCliTokenRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mwaa.model.CreateCliTokenRequest
      .builder()
      .name(EnvironmentName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mwaa.model.CreateCliTokenRequest.ReadOnly =
    zio.aws.mwaa.model.CreateCliTokenRequest.wrap(buildAwsValue())
}
object CreateCliTokenRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mwaa.model.CreateCliTokenRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mwaa.model.CreateCliTokenRequest =
      zio.aws.mwaa.model.CreateCliTokenRequest(name)
    def name: EnvironmentName
    def getName: ZIO[Any, Nothing, EnvironmentName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mwaa.model.CreateCliTokenRequest
  ) extends zio.aws.mwaa.model.CreateCliTokenRequest.ReadOnly {
    override val name: EnvironmentName =
      zio.aws.mwaa.model.primitives.EnvironmentName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mwaa.model.CreateCliTokenRequest
  ): zio.aws.mwaa.model.CreateCliTokenRequest.ReadOnly = new Wrapper(impl)
}
