package zio.aws.mwaa.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mwaa.model.primitives.{
  Hostname,
  SyntheticCreateCliTokenResponseToken
}
import scala.jdk.CollectionConverters.*
final case class CreateCliTokenResponse(
    cliToken: Option[SyntheticCreateCliTokenResponseToken] = None,
    webServerHostname: Option[Hostname] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mwaa.model.CreateCliTokenResponse = {
    import CreateCliTokenResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mwaa.model.CreateCliTokenResponse
      .builder()
      .optionallyWith(
        cliToken.map(value =>
          SyntheticCreateCliTokenResponseToken.unwrap(value): java.lang.String
        )
      )(_.cliToken)
      .optionallyWith(
        webServerHostname.map(value => Hostname.unwrap(value): java.lang.String)
      )(_.webServerHostname)
      .build()
  }
  def asReadOnly: zio.aws.mwaa.model.CreateCliTokenResponse.ReadOnly =
    zio.aws.mwaa.model.CreateCliTokenResponse.wrap(buildAwsValue())
}
object CreateCliTokenResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mwaa.model.CreateCliTokenResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mwaa.model.CreateCliTokenResponse =
      zio.aws.mwaa.model.CreateCliTokenResponse(
        cliToken.map(value => value),
        webServerHostname.map(value => value)
      )
    def cliToken: Option[SyntheticCreateCliTokenResponseToken]
    def webServerHostname: Option[Hostname]
    def getCliToken: ZIO[Any, AwsError, SyntheticCreateCliTokenResponseToken] =
      AwsError.unwrapOptionField("cliToken", cliToken)
    def getWebServerHostname: ZIO[Any, AwsError, Hostname] =
      AwsError.unwrapOptionField("webServerHostname", webServerHostname)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mwaa.model.CreateCliTokenResponse
  ) extends zio.aws.mwaa.model.CreateCliTokenResponse.ReadOnly {
    override val cliToken: Option[SyntheticCreateCliTokenResponseToken] = scala
      .Option(impl.cliToken())
      .map(value =>
        zio.aws.mwaa.model.primitives
          .SyntheticCreateCliTokenResponseToken(value)
      )
    override val webServerHostname: Option[Hostname] = scala
      .Option(impl.webServerHostname())
      .map(value => zio.aws.mwaa.model.primitives.Hostname(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mwaa.model.CreateCliTokenResponse
  ): zio.aws.mwaa.model.CreateCliTokenResponse.ReadOnly = new Wrapper(impl)
}
