package zio.aws.mwaa.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mwaa.model.primitives.{
  MinWorkers,
  IamRoleArn,
  S3BucketArn,
  ConfigValue,
  EnvironmentClass,
  Schedulers,
  WeeklyMaintenanceWindowStart,
  TagValue,
  EnvironmentName,
  KmsKey,
  S3ObjectVersion,
  AirflowVersion,
  MaxWorkers,
  ConfigKey,
  RelativePath,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class CreateEnvironmentRequest(
    airflowConfigurationOptions: Option[Map[ConfigKey, ConfigValue]] = None,
    airflowVersion: Option[AirflowVersion] = None,
    dagS3Path: RelativePath,
    environmentClass: Option[EnvironmentClass] = None,
    executionRoleArn: IamRoleArn,
    kmsKey: Option[KmsKey] = None,
    loggingConfiguration: Option[zio.aws.mwaa.model.LoggingConfigurationInput] =
      None,
    maxWorkers: Option[MaxWorkers] = None,
    minWorkers: Option[MinWorkers] = None,
    name: EnvironmentName,
    networkConfiguration: zio.aws.mwaa.model.NetworkConfiguration,
    pluginsS3ObjectVersion: Option[S3ObjectVersion] = None,
    pluginsS3Path: Option[RelativePath] = None,
    requirementsS3ObjectVersion: Option[S3ObjectVersion] = None,
    requirementsS3Path: Option[RelativePath] = None,
    schedulers: Option[Schedulers] = None,
    sourceBucketArn: S3BucketArn,
    tags: Option[Map[TagKey, TagValue]] = None,
    webserverAccessMode: Option[zio.aws.mwaa.model.WebserverAccessMode] = None,
    weeklyMaintenanceWindowStart: Option[WeeklyMaintenanceWindowStart] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mwaa.model.CreateEnvironmentRequest = {
    import CreateEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mwaa.model.CreateEnvironmentRequest
      .builder()
      .optionallyWith(
        airflowConfigurationOptions.map(value =>
          value
            .map({ case (key, value) =>
              (ConfigKey.unwrap(key): java.lang.String) -> (ConfigValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.airflowConfigurationOptions)
      .optionallyWith(
        airflowVersion.map(value =>
          AirflowVersion.unwrap(value): java.lang.String
        )
      )(_.airflowVersion)
      .dagS3Path(RelativePath.unwrap(dagS3Path): java.lang.String)
      .optionallyWith(
        environmentClass.map(value =>
          EnvironmentClass.unwrap(value): java.lang.String
        )
      )(_.environmentClass)
      .executionRoleArn(IamRoleArn.unwrap(executionRoleArn): java.lang.String)
      .optionallyWith(
        kmsKey.map(value => KmsKey.unwrap(value): java.lang.String)
      )(_.kmsKey)
      .optionallyWith(loggingConfiguration.map(value => value.buildAwsValue()))(
        _.loggingConfiguration
      )
      .optionallyWith(
        maxWorkers.map(value => MaxWorkers.unwrap(value): Integer)
      )(_.maxWorkers)
      .optionallyWith(
        minWorkers.map(value => MinWorkers.unwrap(value): Integer)
      )(_.minWorkers)
      .name(EnvironmentName.unwrap(name): java.lang.String)
      .networkConfiguration(networkConfiguration.buildAwsValue())
      .optionallyWith(
        pluginsS3ObjectVersion.map(value =>
          S3ObjectVersion.unwrap(value): java.lang.String
        )
      )(_.pluginsS3ObjectVersion)
      .optionallyWith(
        pluginsS3Path.map(value => RelativePath.unwrap(value): java.lang.String)
      )(_.pluginsS3Path)
      .optionallyWith(
        requirementsS3ObjectVersion.map(value =>
          S3ObjectVersion.unwrap(value): java.lang.String
        )
      )(_.requirementsS3ObjectVersion)
      .optionallyWith(
        requirementsS3Path.map(value =>
          RelativePath.unwrap(value): java.lang.String
        )
      )(_.requirementsS3Path)
      .optionallyWith(
        schedulers.map(value => Schedulers.unwrap(value): Integer)
      )(_.schedulers)
      .sourceBucketArn(S3BucketArn.unwrap(sourceBucketArn): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(webserverAccessMode.map(value => value.unwrap))(
        _.webserverAccessMode
      )
      .optionallyWith(
        weeklyMaintenanceWindowStart.map(value =>
          WeeklyMaintenanceWindowStart.unwrap(value): java.lang.String
        )
      )(_.weeklyMaintenanceWindowStart)
      .build()
  }
  def asReadOnly: zio.aws.mwaa.model.CreateEnvironmentRequest.ReadOnly =
    zio.aws.mwaa.model.CreateEnvironmentRequest.wrap(buildAwsValue())
}
object CreateEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mwaa.model.CreateEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mwaa.model.CreateEnvironmentRequest =
      zio.aws.mwaa.model.CreateEnvironmentRequest(
        airflowConfigurationOptions.map(value => value),
        airflowVersion.map(value => value),
        dagS3Path,
        environmentClass.map(value => value),
        executionRoleArn,
        kmsKey.map(value => value),
        loggingConfiguration.map(value => value.asEditable),
        maxWorkers.map(value => value),
        minWorkers.map(value => value),
        name,
        networkConfiguration.asEditable,
        pluginsS3ObjectVersion.map(value => value),
        pluginsS3Path.map(value => value),
        requirementsS3ObjectVersion.map(value => value),
        requirementsS3Path.map(value => value),
        schedulers.map(value => value),
        sourceBucketArn,
        tags.map(value => value),
        webserverAccessMode.map(value => value),
        weeklyMaintenanceWindowStart.map(value => value)
      )
    def airflowConfigurationOptions: Option[Map[ConfigKey, ConfigValue]]
    def airflowVersion: Option[AirflowVersion]
    def dagS3Path: RelativePath
    def environmentClass: Option[EnvironmentClass]
    def executionRoleArn: IamRoleArn
    def kmsKey: Option[KmsKey]
    def loggingConfiguration
        : Option[zio.aws.mwaa.model.LoggingConfigurationInput.ReadOnly]
    def maxWorkers: Option[MaxWorkers]
    def minWorkers: Option[MinWorkers]
    def name: EnvironmentName
    def networkConfiguration: zio.aws.mwaa.model.NetworkConfiguration.ReadOnly
    def pluginsS3ObjectVersion: Option[S3ObjectVersion]
    def pluginsS3Path: Option[RelativePath]
    def requirementsS3ObjectVersion: Option[S3ObjectVersion]
    def requirementsS3Path: Option[RelativePath]
    def schedulers: Option[Schedulers]
    def sourceBucketArn: S3BucketArn
    def tags: Option[Map[TagKey, TagValue]]
    def webserverAccessMode: Option[zio.aws.mwaa.model.WebserverAccessMode]
    def weeklyMaintenanceWindowStart: Option[WeeklyMaintenanceWindowStart]
    def getAirflowConfigurationOptions
        : ZIO[Any, AwsError, Map[ConfigKey, ConfigValue]] =
      AwsError.unwrapOptionField(
        "airflowConfigurationOptions",
        airflowConfigurationOptions
      )
    def getAirflowVersion: ZIO[Any, AwsError, AirflowVersion] =
      AwsError.unwrapOptionField("airflowVersion", airflowVersion)
    def getDagS3Path: ZIO[Any, Nothing, RelativePath] = ZIO.succeed(dagS3Path)
    def getEnvironmentClass: ZIO[Any, AwsError, EnvironmentClass] =
      AwsError.unwrapOptionField("environmentClass", environmentClass)
    def getExecutionRoleArn: ZIO[Any, Nothing, IamRoleArn] =
      ZIO.succeed(executionRoleArn)
    def getKmsKey: ZIO[Any, AwsError, KmsKey] =
      AwsError.unwrapOptionField("kmsKey", kmsKey)
    def getLoggingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.mwaa.model.LoggingConfigurationInput.ReadOnly
    ] = AwsError.unwrapOptionField("loggingConfiguration", loggingConfiguration)
    def getMaxWorkers: ZIO[Any, AwsError, MaxWorkers] =
      AwsError.unwrapOptionField("maxWorkers", maxWorkers)
    def getMinWorkers: ZIO[Any, AwsError, MinWorkers] =
      AwsError.unwrapOptionField("minWorkers", minWorkers)
    def getName: ZIO[Any, Nothing, EnvironmentName] = ZIO.succeed(name)
    def getNetworkConfiguration
        : ZIO[Any, Nothing, zio.aws.mwaa.model.NetworkConfiguration.ReadOnly] =
      ZIO.succeed(networkConfiguration)
    def getPluginsS3ObjectVersion: ZIO[Any, AwsError, S3ObjectVersion] =
      AwsError.unwrapOptionField(
        "pluginsS3ObjectVersion",
        pluginsS3ObjectVersion
      )
    def getPluginsS3Path: ZIO[Any, AwsError, RelativePath] =
      AwsError.unwrapOptionField("pluginsS3Path", pluginsS3Path)
    def getRequirementsS3ObjectVersion: ZIO[Any, AwsError, S3ObjectVersion] =
      AwsError.unwrapOptionField(
        "requirementsS3ObjectVersion",
        requirementsS3ObjectVersion
      )
    def getRequirementsS3Path: ZIO[Any, AwsError, RelativePath] =
      AwsError.unwrapOptionField("requirementsS3Path", requirementsS3Path)
    def getSchedulers: ZIO[Any, AwsError, Schedulers] =
      AwsError.unwrapOptionField("schedulers", schedulers)
    def getSourceBucketArn: ZIO[Any, Nothing, S3BucketArn] =
      ZIO.succeed(sourceBucketArn)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getWebserverAccessMode
        : ZIO[Any, AwsError, zio.aws.mwaa.model.WebserverAccessMode] =
      AwsError.unwrapOptionField("webserverAccessMode", webserverAccessMode)
    def getWeeklyMaintenanceWindowStart
        : ZIO[Any, AwsError, WeeklyMaintenanceWindowStart] =
      AwsError.unwrapOptionField(
        "weeklyMaintenanceWindowStart",
        weeklyMaintenanceWindowStart
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mwaa.model.CreateEnvironmentRequest
  ) extends zio.aws.mwaa.model.CreateEnvironmentRequest.ReadOnly {
    override val airflowConfigurationOptions
        : Option[Map[ConfigKey, ConfigValue]] = scala
      .Option(impl.airflowConfigurationOptions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mwaa.model.primitives.ConfigKey(
              key
            ) -> zio.aws.mwaa.model.primitives.ConfigValue(value)
          })
          .toMap
      )
    override val airflowVersion: Option[AirflowVersion] = scala
      .Option(impl.airflowVersion())
      .map(value => zio.aws.mwaa.model.primitives.AirflowVersion(value))
    override val dagS3Path: RelativePath =
      zio.aws.mwaa.model.primitives.RelativePath(impl.dagS3Path())
    override val environmentClass: Option[EnvironmentClass] = scala
      .Option(impl.environmentClass())
      .map(value => zio.aws.mwaa.model.primitives.EnvironmentClass(value))
    override val executionRoleArn: IamRoleArn =
      zio.aws.mwaa.model.primitives.IamRoleArn(impl.executionRoleArn())
    override val kmsKey: Option[KmsKey] = scala
      .Option(impl.kmsKey())
      .map(value => zio.aws.mwaa.model.primitives.KmsKey(value))
    override val loggingConfiguration
        : Option[zio.aws.mwaa.model.LoggingConfigurationInput.ReadOnly] = scala
      .Option(impl.loggingConfiguration())
      .map(value => zio.aws.mwaa.model.LoggingConfigurationInput.wrap(value))
    override val maxWorkers: Option[MaxWorkers] = scala
      .Option(impl.maxWorkers())
      .map(value => zio.aws.mwaa.model.primitives.MaxWorkers(value))
    override val minWorkers: Option[MinWorkers] = scala
      .Option(impl.minWorkers())
      .map(value => zio.aws.mwaa.model.primitives.MinWorkers(value))
    override val name: EnvironmentName =
      zio.aws.mwaa.model.primitives.EnvironmentName(impl.name())
    override val networkConfiguration
        : zio.aws.mwaa.model.NetworkConfiguration.ReadOnly =
      zio.aws.mwaa.model.NetworkConfiguration.wrap(impl.networkConfiguration())
    override val pluginsS3ObjectVersion: Option[S3ObjectVersion] = scala
      .Option(impl.pluginsS3ObjectVersion())
      .map(value => zio.aws.mwaa.model.primitives.S3ObjectVersion(value))
    override val pluginsS3Path: Option[RelativePath] = scala
      .Option(impl.pluginsS3Path())
      .map(value => zio.aws.mwaa.model.primitives.RelativePath(value))
    override val requirementsS3ObjectVersion: Option[S3ObjectVersion] = scala
      .Option(impl.requirementsS3ObjectVersion())
      .map(value => zio.aws.mwaa.model.primitives.S3ObjectVersion(value))
    override val requirementsS3Path: Option[RelativePath] = scala
      .Option(impl.requirementsS3Path())
      .map(value => zio.aws.mwaa.model.primitives.RelativePath(value))
    override val schedulers: Option[Schedulers] = scala
      .Option(impl.schedulers())
      .map(value => zio.aws.mwaa.model.primitives.Schedulers(value))
    override val sourceBucketArn: S3BucketArn =
      zio.aws.mwaa.model.primitives.S3BucketArn(impl.sourceBucketArn())
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mwaa.model.primitives
              .TagKey(key) -> zio.aws.mwaa.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val webserverAccessMode
        : Option[zio.aws.mwaa.model.WebserverAccessMode] = scala
      .Option(impl.webserverAccessMode())
      .map(value => zio.aws.mwaa.model.WebserverAccessMode.wrap(value))
    override val weeklyMaintenanceWindowStart
        : Option[WeeklyMaintenanceWindowStart] = scala
      .Option(impl.weeklyMaintenanceWindowStart())
      .map(value =>
        zio.aws.mwaa.model.primitives.WeeklyMaintenanceWindowStart(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mwaa.model.CreateEnvironmentRequest
  ): zio.aws.mwaa.model.CreateEnvironmentRequest.ReadOnly = new Wrapper(impl)
}
